/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.IOException;
import jec.httpclient.Credentials;
import jec.httpclient.HostConfiguration;
import jec.httpclient.HttpClient;
import jec.httpclient.HttpState;
import jec.httpclient.HttpURL;
import jec.httpclient.UsernamePasswordCredentials;
import org.apache.webdav.lib.WebdavState;

public abstract class WebdavSession {
    protected HttpClient client;
    protected Credentials hostCredentials = null;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected Credentials proxyCredentials = null;
    protected int debug = 0;

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public HttpClient getSessionInstance(HttpURL httpURL) throws IOException {
        return this.getSessionInstance(httpURL, false);
    }

    public HttpClient getSessionInstance(HttpURL httpURL, boolean reset) throws IOException {
        if (reset || this.client == null) {
            String userName;
            this.client = new HttpClient();
            this.client.setState(new WebdavState());
            HostConfiguration hostConfig = this.client.getHostConfiguration();
            hostConfig.setHost(httpURL);
            if (this.proxyHost != null && this.proxyPort > 0) {
                hostConfig.setProxy(this.proxyHost, this.proxyPort);
            }
            if (this.hostCredentials == null && (userName = httpURL.getUser()) != null && userName.length() > 0) {
                this.hostCredentials = new UsernamePasswordCredentials(userName, httpURL.getPassword());
            }
            if (this.hostCredentials != null) {
                HttpState clientState = this.client.getState();
                clientState.setCredentials(null, httpURL.getHost(), this.hostCredentials);
                clientState.setAuthenticationPreemptive(true);
            }
            if (this.proxyCredentials != null) {
                this.client.getState().setProxyCredentials(null, this.proxyHost, this.proxyCredentials);
            }
        }
        return this.client;
    }

    public void setCredentials(Credentials credentials) {
        this.hostCredentials = credentials;
    }

    public void setProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void setProxyCredentials(Credentials credentials) {
        this.proxyCredentials = credentials;
    }

    public void closeSession() throws IOException {
        if (this.client != null) {
            this.client.getHttpConnectionManager().getConnection(this.client.getHostConfiguration()).close();
            this.client = null;
        }
    }

    public synchronized void closeSession(HttpClient client) throws IOException {
        this.closeSession();
    }
}

