/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jec.httpclient.HttpURL;
import jec.httpclient.HttpsURL;
import jec.httpclient.URIException;
import jec.httpclient.util.URIUtil;
import org.apache.webdav.lib.WebdavException;
import org.apache.webdav.lib.WebdavResource;

public class WebdavFile
extends File {
    public static final char davSeparatorChar = '/';
    public static final String davSeparator = String.valueOf('/');
    private HttpURL httpUrl = null;
    private String relPath = null;

    public WebdavFile(WebdavFile parent, String child) throws URIException {
        this(parent.getAbsolutePath() + davSeparator + child, parent.getUser(), parent.getPass());
    }

    public WebdavFile(String pathname, String user, String pass) throws URIException {
        this(new HttpURL(user, pass, null, -1, pathname));
    }

    public WebdavFile(URL url, String user, String pass) throws URIException {
        this(url.getProtocol().equals("https") ? new HttpsURL(user, pass, url.getHost(), url.getPort(), url.getPath()) : new HttpURL(user, pass, url.getHost(), url.getPort(), url.getPath()));
    }

    public WebdavFile(String parent, String child, String user, String pass) throws URIException {
        this(parent + davSeparator + child, user, pass);
    }

    public WebdavFile(HttpURL httpUrl) throws URIException {
        super(httpUrl.getURI());
        this.httpUrl = httpUrl;
    }

    public WebdavFile(String aPath) {
        super(aPath);
        this.relPath = aPath;
    }

    private WebdavResource createRes() {
        try {
            if (this.httpUrl == null) {
                throw new WebdavException("this method is not supported with relative paths");
            }
            return new WebdavResource(this.httpUrl);
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
    }

    private void closeRes(WebdavResource res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
    }

    private File[] toFileArray(List fileList) {
        File[] files = new File[fileList.size()];
        Iterator it = fileList.iterator();
        for (int i2 = 0; i2 < files.length; ++i2) {
            files[i2] = (WebdavFile)it.next();
        }
        return files;
    }

    public String getUser() throws URIException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getUser();
    }

    public String getPass() throws URIException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getPassword();
    }

    public String getName() {
        if (this.relPath != null) {
            return this.relPath;
        }
        String escapedPath = this.httpUrl.getEscapedPath();
        String escapedName = URIUtil.getName(escapedPath.endsWith("/") ? escapedPath.substring(0, escapedPath.length() - 1) : escapedPath);
        try {
            return URIUtil.decode(escapedName);
        }
        catch (URIException e2) {
            return escapedName;
        }
    }

    public String getParent() {
        if (this.relPath != null) {
            return null;
        }
        String escapedPath = this.httpUrl.getEscapedPath();
        String parent = escapedPath.substring(0, escapedPath.lastIndexOf(47, escapedPath.length() - 2) + 1);
        if (parent.length() <= 1) {
            return null;
        }
        try {
            return URIUtil.decode(parent);
        }
        catch (URIException e2) {
            return parent;
        }
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            return new WebdavFile(parent, this.getUser(), this.getPass());
        }
        catch (URIException e2) {
            throw new WebdavException(e2);
        }
    }

    public String getPath() {
        if (this.relPath != null) {
            return this.relPath;
        }
        try {
            return this.httpUrl.getURI();
        }
        catch (URIException e2) {
            throw new WebdavException(e2);
        }
    }

    public boolean isAbsolute() {
        return this.relPath == null;
    }

    public String getAbsolutePath() {
        return this.getPath();
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public File getCanonicalFile() {
        return this;
    }

    public URL toURL() throws MalformedURLException {
        if (this.relPath != null) {
            return null;
        }
        try {
            return new URL(this.httpUrl.getURI());
        }
        catch (URIException e2) {
            throw new MalformedURLException(e2.getMessage());
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = !res.isLocked();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean exists() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.exists();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean isDirectory() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.isCollection();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.getIsHidden();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public long lastModified() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            long l2 = res.getGetLastModified();
            return l2;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public long length() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            long l2 = res.getGetContentLength();
            return l2;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean createNewFile() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.putMethod("");
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean delete() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.deleteMethod();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public void deleteOnExit() {
        throw new WebdavException("this method is not implemented");
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(FilenameFilter filter) {
        File[] files = this.listFiles(filter);
        String[] names = new String[files.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = files[i2].getAbsolutePath();
        }
        return names;
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FilenameFilter filter) {
        WebdavResource res = null;
        try {
            res = this.createRes();
            WebdavResource[] allFiles = res.listWebdavResources();
            if (allFiles == null) {
                File[] fileArray = null;
                return fileArray;
            }
            ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
            for (int i2 = 0; i2 < allFiles.length; ++i2) {
                if (filter != null && !filter.accept(this, allFiles[i2].getDisplayName())) continue;
                filtered.add(new WebdavFile(allFiles[i2].getHttpURL()));
            }
            File[] fileArray = this.toFileArray(filtered);
            return fileArray;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public File[] listFiles(FileFilter filter) {
        WebdavResource res = null;
        try {
            res = this.createRes();
            WebdavResource[] allFiles = res.listWebdavResources();
            if (allFiles == null) {
                File[] fileArray = null;
                return fileArray;
            }
            ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
            for (int i2 = 0; i2 < allFiles.length; ++i2) {
                WebdavFile file = new WebdavFile(allFiles[i2].getHttpURL());
                if (filter != null && !filter.accept(file)) continue;
                filtered.add(file);
            }
            File[] fileArray = this.toFileArray(filtered);
            return fileArray;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean mkdir() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.mkcolMethod();
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean mkdirs() {
        return this.mkdir();
    }

    public boolean renameTo(File dest) {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.moveMethod(dest.getAbsolutePath());
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public boolean setLastModified(long time) {
        throw new WebdavException("this method is not implemented");
    }

    public boolean setReadOnly() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            res.setOverwrite(false);
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
        finally {
            this.closeRes(res);
        }
    }

    public static File[] listRoots() {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix) {
        return WebdavFile.createTempFile(prefix, suffix, null);
    }

    public String toString() {
        if (this.relPath != null) {
            return this.relPath;
        }
        return this.httpUrl.getEscapedURI();
    }

    public int compareTo(File pathname) {
        if (pathname instanceof WebdavFile) {
            WebdavFile df = (WebdavFile)pathname;
            return df.getPath().compareTo(this.getPath());
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((File)o);
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof WebdavFile) {
            WebdavFile xf = (WebdavFile)x;
            return xf.getPath().equals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

