/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.util;

import java.util.BitSet;
import jec.httpclient.NameValuePair;
import jec.httpclient.URIException;
import jec.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingUtil {
    private static final Log LOG;
    private static final BitSet WWW_FORM_URL;

    public static String formUrlEncode(NameValuePair[] pairs, String charset) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < pairs.length; ++i2) {
            if (pairs[i2].getName() == null) continue;
            if (i2 > 0) {
                buf.append("&");
            }
            String queryName = pairs[i2].getName();
            try {
                queryName = URIUtil.encode(queryName, WWW_FORM_URL, charset).replace(' ', '+');
            }
            catch (URIException urie) {
                LOG.error((Object)("Error encoding pair name: " + queryName), (Throwable)urie);
            }
            buf.append(queryName);
            buf.append("=");
            if (pairs[i2].getValue() == null) continue;
            String queryValue = pairs[i2].getValue();
            try {
                queryValue = URIUtil.encode(queryValue, WWW_FORM_URL, charset).replace(' ', '+');
            }
            catch (URIException urie) {
                LOG.error((Object)("Error encoding pair value: " + queryValue), (Throwable)urie);
            }
            buf.append(queryValue);
        }
        return buf.toString();
    }

    private EncodingUtil() {
    }

    static {
        int i2;
        LOG = LogFactory.getLog((Class)EncodingUtil.class);
        WWW_FORM_URL = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        WWW_FORM_URL.set(32);
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
    }
}

