/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.methods;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpConstants;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import jec.httpclient.NameValuePair;
import jec.httpclient.methods.EntityEnclosingMethod;
import jec.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostMethod
extends EntityEnclosingMethod {
    private static final Log LOG = LogFactory.getLog((Class)PostMethod.class);
    public static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private Vector params = new Vector();

    public PostMethod() {
    }

    public PostMethod(String uri) {
        super(uri);
    }

    public PostMethod(String uri, String tempDir) {
        super(uri, tempDir);
    }

    public PostMethod(String uri, String tempDir, String tempFile) {
        super(uri, tempDir, tempFile);
    }

    public String getName() {
        return "POST";
    }

    protected boolean hasRequestContent() {
        LOG.trace((Object)"enter PostMethod.hasRequestContent()");
        if (!this.params.isEmpty()) {
            return true;
        }
        return super.hasRequestContent();
    }

    protected void clearRequestBody() {
        LOG.trace((Object)"enter PostMethod.clearRequestBody()");
        this.params.clear();
        super.clearRequestBody();
    }

    protected byte[] generateRequestBody() {
        LOG.trace((Object)"enter PostMethod.renerateRequestBody()");
        if (!this.params.isEmpty()) {
            String content = EncodingUtil.formUrlEncode(this.getParameters(), this.getRequestCharSet());
            return HttpConstants.getContentBytes(content);
        }
        return super.generateRequestBody();
    }

    public void setParameter(String parameterName, String parameterValue) {
        LOG.trace((Object)"enter PostMethod.setParameter(String, String)");
        this.removeParameter(parameterName);
        this.addParameter(parameterName, parameterValue);
    }

    public NameValuePair getParameter(String paramName) {
        LOG.trace((Object)"enter PostMethod.getParameter(String)");
        if (paramName == null) {
            return null;
        }
        Iterator iter = this.params.iterator();
        while (iter.hasNext()) {
            NameValuePair parameter = (NameValuePair)iter.next();
            if (!paramName.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public NameValuePair[] getParameters() {
        LOG.trace((Object)"enter PostMethod.getParameters()");
        int numPairs = this.params.size();
        Object[] objectArr = this.params.toArray();
        NameValuePair[] nvPairArr = new NameValuePair[numPairs];
        for (int i2 = 0; i2 < numPairs; ++i2) {
            nvPairArr[i2] = (NameValuePair)objectArr[i2];
        }
        return nvPairArr;
    }

    public void addParameter(String paramName, String paramValue) throws IllegalArgumentException {
        LOG.trace((Object)"enter PostMethod.addParameter(String, String)");
        if (paramName == null || paramValue == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        super.clearRequestBody();
        this.params.add(new NameValuePair(paramName, paramValue));
    }

    public void addParameter(NameValuePair param) throws IllegalArgumentException {
        LOG.trace((Object)"enter PostMethod.addParameter(NameValuePair)");
        if (param == null) {
            throw new IllegalArgumentException("NameValuePair may not be null");
        }
        this.addParameter(param.getName(), param.getValue());
    }

    public void addParameters(NameValuePair[] parameters) {
        LOG.trace((Object)"enter PostMethod.addParameters(NameValuePair[])");
        if (parameters == null) {
            LOG.warn((Object)"Attempt to addParameters(null) ignored");
        } else {
            super.clearRequestBody();
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                this.params.add(parameters[i2]);
            }
        }
    }

    public boolean removeParameter(String paramName) throws IllegalArgumentException {
        LOG.trace((Object)"enter PostMethod.removeParameter(String)");
        if (paramName == null) {
            throw new IllegalArgumentException("Argument passed to removeParameter(String) cannot be null");
        }
        boolean removed = false;
        Iterator iter = this.params.iterator();
        while (iter.hasNext()) {
            NameValuePair pair = (NameValuePair)iter.next();
            if (!paramName.equals(pair.getName())) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public boolean removeParameter(String paramName, String paramValue) throws IllegalArgumentException {
        LOG.trace((Object)"enter PostMethod.removeParameter(String, String)");
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        if (paramValue == null) {
            throw new IllegalArgumentException("Parameter value may not be null");
        }
        Iterator iter = this.params.iterator();
        while (iter.hasNext()) {
            NameValuePair pair = (NameValuePair)iter.next();
            if (!paramName.equals(pair.getName()) || !paramValue.equals(pair.getValue())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void setRequestBody(NameValuePair[] parametersBody) throws IllegalArgumentException {
        LOG.trace((Object)"enter PostMethod.setRequestBody(NameValuePair[])");
        if (parametersBody == null) {
            throw new IllegalArgumentException("Array of parameters may not be null");
        }
        this.clearRequestBody();
        this.addParameters(parametersBody);
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (!this.params.isEmpty() && this.getRequestHeader("Content-Type") == null) {
            this.setRequestHeader("Content-Type", FORM_URL_ENCODED_CONTENT_TYPE);
        }
    }
}

