/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.methods;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpMethodBase;
import jec.httpclient.HttpState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog((Class)GetMethod.class);
    private static final String TEMP_DIR = "temp/";
    private File fileData;
    private String tempDir = "temp/";
    private String tempFile = null;
    private boolean useDisk = false;

    public GetMethod() {
        this.setFollowRedirects(true);
    }

    public GetMethod(String uri) {
        super(uri);
        LOG.trace((Object)"enter GetMethod(String)");
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir) {
        super(path);
        LOG.trace((Object)"enter GetMethod(String, String)");
        this.setUseDisk(true);
        this.setTempDir(tempDir);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir, String tempFile) {
        super(path);
        LOG.trace((Object)"enter GetMethod(String, String, String)");
        this.setUseDisk(true);
        this.setTempDir(tempDir);
        this.setTempFile(tempFile);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, File fileData) {
        this(path);
        LOG.trace((Object)"enter GetMethod(String, File)");
        this.useDisk = true;
        this.fileData = fileData;
        this.setFollowRedirects(true);
    }

    public void setFileData(File fileData) {
        this.checkNotUsed();
        this.fileData = fileData;
    }

    public File getFileData() {
        return this.fileData;
    }

    public String getName() {
        return "GET";
    }

    public void setTempDir(String tempDir) {
        this.checkNotUsed();
        this.tempDir = tempDir;
        this.setUseDisk(true);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempFile(String tempFile) {
        this.checkNotUsed();
        this.tempFile = tempFile;
    }

    public String getTempFile() {
        return this.tempFile;
    }

    public void setUseDisk(boolean useDisk) {
        this.checkNotUsed();
        this.useDisk = useDisk;
    }

    public boolean getUseDisk() {
        return this.useDisk;
    }

    public void recycle() {
        LOG.trace((Object)"enter GetMethod.recycle()");
        super.recycle();
        this.fileData = null;
        this.setFollowRedirects(true);
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter GetMethod.readResponseBody(HttpState, HttpConnection)");
        super.readResponseBody(state, conn);
        FileOutputStream out = null;
        if (this.useDisk) {
            int len;
            out = new FileOutputStream(this.createTempFile());
            InputStream in = this.getResponseBodyAsStream();
            byte[] buffer = new byte[10000];
            while ((len = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            this.setResponseStream(new FileInputStream(this.createTempFile()));
        }
    }

    private File createTempFile() {
        if (this.fileData == null) {
            File dir = new File(this.tempDir);
            dir.deleteOnExit();
            dir.mkdirs();
            String tempFileName = null;
            if (this.tempFile == null) {
                String encodedPath = URLEncoder.encode(this.getPath());
                int length = encodedPath.length();
                if (length > 200) {
                    encodedPath = encodedPath.substring(length - 190, length);
                }
                tempFileName = System.currentTimeMillis() + "-" + encodedPath + ".tmp";
            } else {
                tempFileName = this.tempFile;
            }
            this.fileData = new File(this.tempDir, tempFileName);
            this.fileData = new File(this.tempDir, tempFileName);
            this.fileData.deleteOnExit();
        }
        return this.fileData;
    }
}

