/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.cookie;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import jec.httpclient.Cookie;
import jec.httpclient.Header;
import jec.httpclient.HeaderElement;
import jec.httpclient.HttpException;
import jec.httpclient.NameValuePair;
import jec.httpclient.cookie.CookieSpec;
import jec.httpclient.cookie.MalformedCookieException;
import jec.httpclient.util.DateParseException;
import jec.httpclient.util.DateParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieSpecBase
implements CookieSpec {
    protected static final Log LOG = LogFactory.getLog((Class)CookieSpec.class);

    public Cookie[] parse(String host, int port, String path, boolean secure, String header) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, Header)");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        HeaderElement[] headerElements = null;
        try {
            headerElements = HeaderElement.parse(header);
        }
        catch (HttpException e2) {
            throw new MalformedCookieException(e2.getMessage());
        }
        String defaultPath = path;
        int lastSlashIndex = defaultPath.lastIndexOf("/");
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        Cookie[] cookies = new Cookie[headerElements.length];
        for (int i2 = 0; i2 < headerElements.length; ++i2) {
            HeaderElement headerelement = headerElements[i2];
            Cookie cookie = null;
            try {
                cookie = new Cookie(host, headerelement.getName(), headerelement.getValue(), defaultPath, null, false);
            }
            catch (IllegalArgumentException e3) {
                throw new MalformedCookieException(e3.getMessage());
            }
            NameValuePair[] parameters = headerelement.getParameters();
            if (parameters != null) {
                for (int j2 = 0; j2 < parameters.length; ++j2) {
                    this.parseAttribute(parameters[j2], cookie);
                }
            }
            cookies[i2] = cookie;
        }
        return cookies;
    }

    public Cookie[] parse(String host, int port, String path, boolean secure, Header header) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, String)");
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        return this.parse(host, port, path, secure, header.getValue());
    }

    public void parseAttribute(NameValuePair attribute, Cookie cookie) throws MalformedCookieException {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String paramName = attribute.getName().toLowerCase();
        String paramValue = attribute.getValue();
        if (paramName.equals("path")) {
            if (paramValue == null || paramValue.trim().equals("")) {
                paramValue = "/";
            }
            cookie.setPath(paramValue);
            cookie.setPathAttributeSpecified(true);
        } else if (paramName.equals("domain")) {
            if (paramValue == null) {
                throw new MalformedCookieException("Missing value for domain attribute");
            }
            if (paramValue.trim().equals("")) {
                throw new MalformedCookieException("Blank value for domain attribute");
            }
            cookie.setDomain(paramValue);
            cookie.setDomainAttributeSpecified(true);
        } else if (paramName.equals("max-age")) {
            int age;
            if (paramValue == null) {
                throw new MalformedCookieException("Missing value for max-age attribute");
            }
            try {
                age = Integer.parseInt(paramValue);
            }
            catch (NumberFormatException e2) {
                throw new MalformedCookieException("Invalid max-age attribute: " + e2.getMessage());
            }
            cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
        } else if (paramName.equals("secure")) {
            cookie.setSecure(true);
        } else if (paramName.equals("comment")) {
            cookie.setComment(paramValue);
        } else if (paramName.equals("expires")) {
            if (paramValue == null) {
                throw new MalformedCookieException("Missing value for expires attribute");
            }
            if (paramValue.length() > 1 && paramValue.startsWith("'") && paramValue.endsWith("'")) {
                paramValue = paramValue.substring(1, paramValue.length() - 1);
            }
            try {
                cookie.setExpiryDate(DateParser.parseDate(paramValue));
            }
            catch (DateParseException dpe) {
                LOG.debug((Object)"Error parsing cookie date", (Throwable)dpe);
                throw new MalformedCookieException("Unable to parse expiration date parameter: " + paramValue);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unrecognized cookie attribute: " + attribute.toString()));
        }
    }

    public void validate(String host, int port, String path, boolean secure, Cookie cookie) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.validate(String, port, path, boolean, Cookie)");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        if (cookie.getVersion() < 0) {
            throw new MalformedCookieException("Illegal version number " + cookie.getValue());
        }
        if (host.indexOf(".") >= 0) {
            if (!host.endsWith(cookie.getDomain())) {
                String s = cookie.getDomain();
                if (s.startsWith(".")) {
                    s = s.substring(1, s.length());
                }
                if (!host.equals(s)) {
                    throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + host + "\"");
                }
            }
        } else if (!host.equals(cookie.getDomain())) {
            throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + host + "\"");
        }
        if (!path.startsWith(cookie.getPath())) {
            throw new MalformedCookieException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + path + "\"");
        }
    }

    public boolean match(String host, int port, String path, boolean secure, Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        if (cookie.getDomain() == null) {
            LOG.warn((Object)"Invalid cookie state: domain not specified");
            return false;
        }
        if (cookie.getPath() == null) {
            LOG.warn((Object)"Invalid cookie state: path not specified");
            return false;
        }
        return !(cookie.getExpiryDate() != null && !cookie.getExpiryDate().after(new Date()) || !CookieSpecBase.domainMatch(host, cookie.getDomain()) || !CookieSpecBase.pathMatch(path, cookie.getPath()) || cookie.getSecure() && !secure);
    }

    private static boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith(".") && host.endsWith(domain);
        return match;
    }

    private static boolean pathMatch(String path, String topmostPath) {
        boolean match = path.startsWith(topmostPath);
        if (match && path.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match = path.charAt(topmostPath.length()) == PATH_DELIM_CHAR;
        }
        return match;
    }

    public Cookie[] match(String host, int port, String path, boolean secure, Cookie[] cookies) {
        LOG.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie[])");
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (cookies == null) {
            throw new IllegalArgumentException("Cookie array may not be null");
        }
        if (path.trim().equals("")) {
            path = "/";
        }
        host = host.toLowerCase();
        if (cookies.length <= 0) {
            return null;
        }
        LinkedList matching = new LinkedList();
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            if (!this.match(host, port, path, secure, cookies[i2])) continue;
            CookieSpecBase.addInPathOrder(matching, cookies[i2]);
        }
        return matching.toArray(new Cookie[matching.size()]);
    }

    private static void addInPathOrder(List list, Cookie addCookie) {
        Cookie c2;
        int i2 = 0;
        for (i2 = 0; i2 < list.size() && addCookie.compare(addCookie, c2 = (Cookie)list.get(i2)) <= 0; ++i2) {
        }
        list.add(i2, addCookie);
    }

    public String formatCookie(Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(cookie.getName());
        buf.append("=");
        String s = cookie.getValue();
        if (s != null) {
            buf.append(s);
        }
        return buf.toString();
    }

    public String formatCookies(Cookie[] cookies) throws IllegalArgumentException {
        LOG.trace((Object)"enter CookieSpecBase.formatCookies(Cookie[])");
        if (cookies == null) {
            throw new IllegalArgumentException("Cookie array may not be null");
        }
        if (cookies.length == 0) {
            throw new IllegalArgumentException("Cookie array may not be empty");
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            if (i2 > 0) {
                buffer.append("; ");
            }
            buffer.append(this.formatCookie(cookies[i2]));
        }
        return buffer.toString();
    }

    public Header formatCookieHeader(Cookie[] cookies) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie[])");
        return new Header("Cookie", this.formatCookies(cookies));
    }

    public Header formatCookieHeader(Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie)");
        return new Header("Cookie", this.formatCookie(cookie));
    }
}

