/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.auth;

import jec.httpclient.Credentials;
import jec.httpclient.HttpException;
import jec.httpclient.NTCredentials;
import jec.httpclient.NTLM;
import jec.httpclient.auth.AuthChallengeParser;
import jec.httpclient.auth.AuthSchemeBase;
import jec.httpclient.auth.AuthenticationException;
import jec.httpclient.auth.MalformedChallengeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMScheme
extends AuthSchemeBase {
    private static final Log LOG = LogFactory.getLog((Class)NTLMScheme.class);
    private String ntlmchallenge = null;

    public NTLMScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        String s = AuthChallengeParser.extractScheme(challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int i2 = challenge.indexOf(32);
        if (i2 != -1) {
            s = challenge.substring(i2, challenge.length());
            this.ntlmchallenge = s.trim();
        } else {
            this.ntlmchallenge = "";
        }
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        return this.ntlmchallenge;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public static String authenticate(NTCredentials credentials, String challenge) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(NTCredentials, String)");
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        NTLM ntlm = new NTLM();
        String s = null;
        try {
            s = ntlm.getResponseFor(challenge, credentials.getUserName(), credentials.getPassword(), credentials.getHost(), credentials.getDomain());
        }
        catch (HttpException e2) {
            throw new AuthenticationException(e2.getMessage());
        }
        return "NTLM " + s;
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(Credentials, String, String)");
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e2) {
            throw new AuthenticationException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        return NTLMScheme.authenticate(ntcredentials, this.ntlmchallenge);
    }
}

