/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jec.httpclient.Header;
import jec.httpclient.HttpConstants;
import jec.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpParser {
    private static final Log LOG = LogFactory.getLog((Class)HttpParser.class);

    private HttpParser() {
    }

    public static byte[] readRawLine(InputStream inputStream) throws IOException {
        int ch;
        LOG.trace((Object)"enter HttpParser.readRawLine()");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
        }
        if (buf.size() == 0) {
            return null;
        }
        return buf.toByteArray();
    }

    public static String readLine(InputStream inputStream) throws IOException {
        LOG.trace((Object)"enter HttpParser.readLine()");
        byte[] rawdata = HttpParser.readRawLine(inputStream);
        if (rawdata == null) {
            return null;
        }
        int len = rawdata.length;
        int offset = 0;
        if (len > 0 && rawdata[len - 1] == 10) {
            ++offset;
            if (len > 1 && rawdata[len - 2] == 13) {
                ++offset;
            }
        }
        return HttpConstants.getString(rawdata, 0, len - offset);
    }

    public static Header[] parseHeaders(InputStream is) throws IOException, HttpException {
        String line;
        LOG.trace((Object)"enter HeaderParser.parseHeaders(HttpConnection, HeaderGroup)");
        ArrayList<Header> headers = new ArrayList<Header>();
        String name = null;
        StringBuffer value = null;
        while ((line = HttpParser.readLine(is)) != null && line.length() >= 1) {
            int colon;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (value == null) continue;
                value.append(' ');
                value.append(line.trim());
                continue;
            }
            if (name != null) {
                headers.add(new Header(name, value.toString()));
            }
            if ((colon = line.indexOf(":")) < 0) {
                throw new HttpException("Unable to parse header: " + line);
            }
            name = line.substring(0, colon).trim();
            value = new StringBuffer(line.substring(colon + 1).trim());
        }
        if (name != null) {
            headers.add(new Header(name, value.toString()));
        }
        return headers.toArray(new Header[headers.size()]);
    }
}

