/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.materialspinner;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.jaredrummler.materialspinner.MaterialSpinnerAdapter;
import com.jaredrummler.materialspinner.MaterialSpinnerAdapterWrapper;
import com.jaredrummler.materialspinner.MaterialSpinnerBaseAdapter;
import com.jaredrummler.materialspinner.R;
import java.util.Arrays;
import java.util.List;

public class MaterialSpinner
extends TextView {
    private OnItemSelectedListener onItemSelectedListener;
    private MaterialSpinnerBaseAdapter adapter;
    private PopupWindow popupWindow;
    private ListView listView;
    private Drawable arrowDrawable;
    private boolean hideArrow;
    private int selectedIndex;
    private int backgroundColor;
    private int arrowColor;
    private int textColor;

    public MaterialSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaterialSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        int top;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialSpinner);
        int defaultColor = this.getTextColors().getDefaultColor();
        this.backgroundColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_background_color, -1);
        this.textColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_text_color, defaultColor);
        this.arrowColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_arrow_tint, this.textColor);
        this.hideArrow = typedArray.getBoolean(R.styleable.MaterialSpinner_ms_hide_arrow, false);
        typedArray.recycle();
        this.setGravity(8388627);
        boolean rtl = false;
        if (Build.VERSION.SDK_INT >= 17) {
            Configuration config = this.getResources().getConfiguration();
            boolean bl = rtl = config.getLayoutDirection() == 1;
            if (rtl) {
                this.setLayoutDirection(1);
                this.setTextDirection(4);
            }
        }
        Resources resources = this.getResources();
        int bottom = top = resources.getDimensionPixelSize(R.dimen.ms__padding_top);
        int right = top;
        int left = top;
        if (rtl) {
            right = resources.getDimensionPixelSize(R.dimen.ms__padding_left);
        } else {
            left = resources.getDimensionPixelSize(R.dimen.ms__padding_left);
        }
        this.setClickable(true);
        this.setPadding(left, top, right, bottom);
        this.setBackgroundResource(R.drawable.ms__selector);
        if (!this.hideArrow) {
            this.arrowDrawable = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.ms__arrow));
            DrawableCompat.setTint((Drawable)this.arrowDrawable, (int)this.arrowColor);
            if (rtl) {
                this.setCompoundDrawablesWithIntrinsicBounds(this.arrowDrawable, null, null, null);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.arrowDrawable, null);
            }
        }
        this.listView = new ListView(context);
        this.listView.setId(this.getId());
        this.listView.setDivider(null);
        this.listView.setItemsCanFocus(true);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position >= MaterialSpinner.this.selectedIndex && position < MaterialSpinner.this.adapter.getCount()) {
                    ++position;
                }
                MaterialSpinner.this.selectedIndex = position;
                Object item = MaterialSpinner.this.adapter.get(position);
                MaterialSpinner.this.adapter.notifyItemSelected(position);
                MaterialSpinner.this.setText(item.toString());
                MaterialSpinner.this.collapse();
                if (MaterialSpinner.this.onItemSelectedListener != null) {
                    MaterialSpinner.this.onItemSelectedListener.onItemSelected(MaterialSpinner.this, position, id2, item);
                }
            }
        });
        this.popupWindow = new PopupWindow(context);
        this.popupWindow.setContentView((View)this.listView);
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.popupWindow.setElevation(16.0f);
            this.popupWindow.setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ms__drawable));
        } else {
            this.popupWindow.setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ms__drop_down_shadow));
        }
        if (this.backgroundColor != -1) {
            this.setBackgroundColor(this.backgroundColor);
        }
        if (this.textColor != defaultColor) {
            this.setTextColor(this.textColor);
        }
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (!MaterialSpinner.this.hideArrow) {
                    MaterialSpinner.this.animateArrow(false);
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.popupWindow.setWidth(View.MeasureSpec.getSize((int)widthMeasureSpec));
        this.popupWindow.setHeight(-2);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 1) {
            if (!this.popupWindow.isShowing()) {
                this.expand();
            } else {
                this.collapse();
            }
        }
        return super.onTouchEvent(event);
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.getBackground().setColorFilter(color, PorterDuff.Mode.SRC_IN);
        this.popupWindow.getBackground().setColorFilter(color, PorterDuff.Mode.SRC_IN);
    }

    public void setTextColor(int color) {
        this.textColor = color;
        super.setTextColor(color);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("state", super.onSaveInstanceState());
        bundle.putInt("selected_index", this.selectedIndex);
        if (this.popupWindow != null) {
            bundle.putBoolean("is_popup_showing", this.popupWindow.isShowing());
            this.collapse();
        } else {
            bundle.putBoolean("is_popup_showing", false);
        }
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle bundle = (Bundle)savedState;
            this.selectedIndex = bundle.getInt("selected_index");
            if (this.adapter != null) {
                this.setText(this.adapter.get(this.selectedIndex).toString());
                this.adapter.notifyItemSelected(this.selectedIndex);
            }
            if (bundle.getBoolean("is_popup_showing") && this.popupWindow != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        MaterialSpinner.this.expand();
                    }
                });
            }
            savedState = bundle.getParcelable("state");
        }
        super.onRestoreInstanceState(savedState);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int position) {
        if (this.adapter != null) {
            if (position >= 0 && position <= this.adapter.getCount()) {
                this.adapter.notifyItemSelected(position);
                this.selectedIndex = position;
                this.setText(this.adapter.get(position).toString());
            } else {
                throw new IllegalArgumentException("Position must be lower than adapter count!");
            }
        }
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public <T> void setItems(@NonNull List<T> items) {
        this.adapter = new MaterialSpinnerAdapter<T>(this.getContext(), items).setTextColor(this.textColor);
        this.setAdapterInternal(this.adapter);
    }

    public <T> void setItems(T ... items) {
        this.setItems(Arrays.asList(items));
    }

    public void setAdapter(@NonNull ListAdapter adapter) {
        this.adapter = new MaterialSpinnerAdapterWrapper(this.getContext(), adapter);
        this.setAdapterInternal(this.adapter);
    }

    private void setAdapterInternal(@NonNull MaterialSpinnerBaseAdapter adapter) {
        this.listView.setAdapter((ListAdapter)adapter);
        this.setText(adapter.get(this.selectedIndex).toString());
    }

    public void expand() {
        if (!this.hideArrow) {
            this.animateArrow(true);
        }
        this.popupWindow.showAsDropDown((View)this);
    }

    public void collapse() {
        if (!this.hideArrow) {
            this.animateArrow(false);
        }
        this.popupWindow.dismiss();
    }

    public void setArrowColor(@ColorInt int color) {
        this.arrowColor = color;
        if (this.arrowDrawable != null) {
            DrawableCompat.setTint((Drawable)this.arrowDrawable, (int)this.arrowColor);
        }
    }

    private void animateArrow(boolean shouldRotateUp) {
        int start = shouldRotateUp ? 0 : 10000;
        int end = shouldRotateUp ? 10000 : 0;
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)this.arrowDrawable, (String)"level", (int[])new int[]{start, end});
        animator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        animator.start();
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(MaterialSpinner var1, int var2, long var3, T var5);
    }
}

