/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.jaredrummler.android.processes.models.AndroidProcess;
import com.jaredrummler.android.processes.models.Cgroup;
import com.jaredrummler.android.processes.models.ControlGroup;
import java.io.IOException;

public class AndroidAppProcess
extends AndroidProcess {
    public boolean foreground;
    public int uid;
    private final Cgroup cgroup;
    public static final Parcelable.Creator<AndroidAppProcess> CREATOR = new Parcelable.Creator<AndroidAppProcess>(){

        public AndroidAppProcess createFromParcel(Parcel source) {
            return new AndroidAppProcess(source);
        }

        public AndroidAppProcess[] newArray(int size) {
            return new AndroidAppProcess[size];
        }
    };

    public AndroidAppProcess(int pid) throws IOException, NotAndroidAppProcessException {
        super(pid);
        this.cgroup = super.cgroup();
        ControlGroup cpuacct = this.cgroup.getGroup("cpuacct");
        ControlGroup cpu = this.cgroup.getGroup("cpu");
        if (cpu == null || cpuacct == null || !cpuacct.group.contains("pid_")) {
            throw new NotAndroidAppProcessException(pid);
        }
        this.foreground = !cpu.group.contains("bg_non_interactive");
        try {
            this.uid = Integer.parseInt(cpuacct.group.split("/")[1].replace("uid_", ""));
        }
        catch (Exception e) {
            this.uid = this.status().getUid();
        }
    }

    public String getPackageName() {
        return this.name.split(":")[0];
    }

    public PackageInfo getPackageInfo(Context context, int flags) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getPackageInfo(this.getPackageName(), flags);
    }

    @Override
    public Cgroup cgroup() {
        return this.cgroup;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.cgroup, flags);
        dest.writeByte((byte)(this.foreground ? 1 : 0));
    }

    protected AndroidAppProcess(Parcel in) {
        super(in);
        this.cgroup = (Cgroup)in.readParcelable(Cgroup.class.getClassLoader());
        this.foreground = in.readByte() != 0;
    }

    public static final class NotAndroidAppProcessException
    extends Exception {
        public NotAndroidAppProcessException(int pid) {
            super(String.format("The process %d does not belong to any application", pid));
        }
    }
}

