/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import com.jaredrummler.android.processes.models.AndroidAppProcess;
import com.jaredrummler.android.processes.models.AndroidProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ProcessManager {
    private ProcessManager() {
        throw new AssertionError((Object)"no instances");
    }

    public static List<AndroidProcess> getRunningProcesses() {
        File[] files;
        ArrayList<AndroidProcess> processes = new ArrayList<AndroidProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidProcess(pid));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningAppProcesses() {
        File[] files;
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidAppProcess(pid));
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException notAndroidAppProcessException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<AndroidProcess> filter(Filter filter) {
        File[] files;
        ArrayList<AndroidProcess> processes = new ArrayList<AndroidProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (filter.pid != -1 && pid != filter.pid) continue;
            try {
                AndroidProcess process = filter.apps ? new AndroidAppProcess(pid) : new AndroidProcess(pid);
                if (filter.name != null && !process.name.contains(filter.name) || filter.ppid != -1 && process.stat().ppid() != filter.ppid) continue;
                processes.add(process);
            }
            catch (IOException iOException) {
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException notAndroidAppProcessException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningForegroundApps(Context ctx) {
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        File[] files = new File("/proc").listFiles();
        PackageManager pm = ctx.getPackageManager();
        for (File file : files) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                AndroidAppProcess process = new AndroidAppProcess(pid);
                if (!process.foreground || process.uid >= 1000 && process.uid <= 9999 || process.name.contains(":") || pm.getLaunchIntentForPackage(process.getPackageName()) == null) continue;
                processes.add(process);
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException notAndroidAppProcessException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static boolean isMyProcessInTheForeground() {
        List<AndroidAppProcess> processes = ProcessManager.getRunningAppProcesses();
        int myPid = Process.myPid();
        for (AndroidAppProcess process : processes) {
            if (process.pid != myPid || !process.foreground) continue;
            return true;
        }
        return false;
    }

    public static List<ActivityManager.RunningAppProcessInfo> getRunningAppProcessInfo(Context ctx) {
        if (Build.VERSION.SDK_INT >= 22) {
            List<AndroidAppProcess> runningAppProcesses = ProcessManager.getRunningAppProcesses();
            ArrayList<ActivityManager.RunningAppProcessInfo> appProcessInfos = new ArrayList<ActivityManager.RunningAppProcessInfo>();
            for (AndroidAppProcess process : runningAppProcesses) {
                ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo(process.name, process.pid, null);
                info.uid = process.uid;
                appProcessInfos.add(info);
            }
            return appProcessInfos;
        }
        ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
        return am.getRunningAppProcesses();
    }

    public static class Filter {
        private String name;
        private int pid = -1;
        private int ppid = -1;
        private boolean apps;

        public Filter setName(String name) {
            this.name = name;
            return this;
        }

        public Filter setPid(int pid) {
            this.pid = pid;
            return this;
        }

        public Filter setPpid(int ppid) {
            this.ppid = ppid;
            return this;
        }

        public Filter setApps(boolean apps) {
            this.apps = apps;
            return this;
        }

        public List<AndroidProcess> run() {
            return ProcessManager.filter(this);
        }
    }

    public static final class ProcessComparator
    implements Comparator<AndroidProcess> {
        @Override
        public int compare(AndroidProcess lhs, AndroidProcess rhs) {
            try {
                int oomScoreAdj1 = lhs.oom_score_adj();
                int oomScoreAdj2 = rhs.oom_score_adj();
                if (oomScoreAdj1 < oomScoreAdj2) {
                    return -1;
                }
                if (oomScoreAdj1 > oomScoreAdj2) {
                    return 1;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return lhs.name.compareToIgnoreCase(rhs.name);
        }
    }
}

