/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.device;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceName {
    private static final String DEVICE_JSON_URL = "https://raw.githubusercontent.com/jaredrummler/AndroidDeviceNames/master/json/codenames/%s.json";
    private static final String SHARED_PREF_NAME = "device_names";

    public static Request with(Context context) {
        return new Request(context.getApplicationContext());
    }

    public static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        String fallback = model.startsWith(manufacturer) ? DeviceName.capitalize(model) : DeviceName.capitalize(manufacturer) + " " + model;
        return DeviceName.getDeviceName(Build.DEVICE, fallback);
    }

    public static String getDeviceName(String codename, String fallback) {
        switch (codename) {
            case "quark": {
                return "DROID Turbo";
            }
            case "a3ltedd": 
            case "a3ulte": 
            case "a3ltezh": 
            case "a3ltechn": 
            case "a3lte": 
            case "a33g": 
            case "a3ltectc": 
            case "a3lteslk": 
            case "a3ltezt": {
                return "Galaxy A3";
            }
            case "a5ltectc": 
            case "a5ltezh": 
            case "a5ulteskt": 
            case "a53g": 
            case "a5ltezt": 
            case "a5lte": 
            case "a5ltechn": 
            case "a5ulte": 
            case "a5ultektt": 
            case "a5ultebmc": 
            case "a5ultelgt": {
                return "Galaxy A5";
            }
            case "a8elte": 
            case "a8hplte": 
            case "a8elteskt": 
            case "a8ltechn": {
                return "Galaxy A8";
            }
            case "vivaltods5m": {
                return "Galaxy Ace 4";
            }
            case "GT-S6802B": 
            case "GT-S6802": 
            case "SCH-i589": 
            case "SCH-i579": 
            case "GT-S6352": 
            case "SCH-I589": 
            case "SCH-I579": {
                return "Galaxy Ace Duos";
            }
            case "GT-S7500L": 
            case "GT-S7500": 
            case "GT-S7500T": 
            case "GT-S7508": 
            case "GT-S7500W": {
                return "Galaxy Ace Plus";
            }
            case "heatqlte": 
            case "heat3gtfnvzw": 
            case "heatnfc3g": {
                return "Galaxy Ace Style";
            }
            case "vivaltolte": 
            case "vivalto5mve3g": 
            case "vivaltonfc3g": 
            case "vivalto3g": 
            case "vivalto3mve3g": {
                return "Galaxy Ace4";
            }
            case "sltechn": 
            case "sltelgt": 
            case "slteskt": 
            case "sltektt": 
            case "sltecan": 
            case "slteatt": 
            case "slte": {
                return "Galaxy Alpha";
            }
            case "rossalte": 
            case "coreprimeltespr": 
            case "rossaltexsa": 
            case "coreprimeltelra": 
            case "coreprimelte": 
            case "coreprimeltevzw": 
            case "coreprimeve3g": 
            case "core33g": 
            case "cprimeltetmo": 
            case "coreprimelteaio": 
            case "cprimeltemtr": 
            case "rossaltectc": 
            case "coreprimeltetfnvzw": 
            case "coreprimevelte": {
                return "Galaxy Core Prime";
            }
            case "kanas3g": 
            case "kanas3gnfc": 
            case "kanas3gcmcc": 
            case "kanas": 
            case "kanas3gctc": {
                return "Galaxy Core2";
            }
            case "e5lte": 
            case "e53g": 
            case "e5ltetfnvzw": 
            case "e5ltetw": {
                return "Galaxy E5";
            }
            case "e7lte": 
            case "e7ltehktw": 
            case "e7ltechn": 
            case "e73g": 
            case "e7ltectc": {
                return "Galaxy E7";
            }
            case "nevis": 
            case "SCH-I629": 
            case "nevis3gcmcc": 
            case "nevisw": 
            case "nevis3g": 
            case "nevisp": 
            case "nevisnvess": 
            case "nevisvess": 
            case "nevisds": {
                return "Galaxy Fame";
            }
            case "grandprimelteatt": {
                return "Galaxy Go Prime";
            }
            case "baffinq3g": 
            case "baffinlitedtv": 
            case "baffinlite": {
                return "Galaxy Grand Neo";
            }
            case "gprimelteacg": 
            case "gprimelteusc": 
            case "grandprimeveltezt": 
            case "grandprimelte": 
            case "fortunaltezh": 
            case "gprimeltetfnvzw": 
            case "gprimeltemtr": 
            case "fortunalte": 
            case "gprimeltecan": 
            case "fortunaltectc": 
            case "grandprimevelteltn": 
            case "gprimeltespr": 
            case "fortuna3gdtv": 
            case "gprimeltetmo": 
            case "fortuna3g": 
            case "grandprimeve3g": 
            case "fortunaltezt": 
            case "grandprimelteaio": 
            case "grandprimevelte": 
            case "grandprimeve3gdtv": {
                return "Galaxy Grand Prime";
            }
            case "ms013g": 
            case "ms01lte": 
            case "ms013gdtv": 
            case "ms01ltelgt": 
            case "ms013gss": 
            case "ms01lteskt": 
            case "ms01ltektt": {
                return "Galaxy Grand2";
            }
            case "j75ltektt": 
            case "j7ltechn": 
            case "j7e3g": 
            case "j7elte": {
                return "Galaxy J7";
            }
            case "toroplus": 
            case "maguro": 
            case "toro": {
                return "Galaxy Nexus";
            }
            case "p4noterf": 
            case "p4noteltektt": 
            case "p4notewifiww": 
            case "p4noterfktt": 
            case "lt03ltektt": 
            case "p4notewifi43241any": 
            case "p4noteltespr": 
            case "p4noteltevzw": 
            case "p4notelte": 
            case "p4noteltelgt": 
            case "lt03ltelgt": 
            case "p4notelteskt": 
            case "lt033g": 
            case "lt03lteskt": 
            case "p4notelteusc": 
            case "p4notewifi": 
            case "p4notewifiany": 
            case "p4notewifiktt": {
                return "Galaxy Note 10.1";
            }
            case "tbltechn": 
            case "tbltecan": 
            case "tblteatt": 
            case "tbeltelgt": 
            case "tbltevzw": 
            case "tbeltektt": 
            case "tbelteskt": 
            case "tbltespr": 
            case "tblteusc": 
            case "SCL24": 
            case "tblte": 
            case "tbltetmo": {
                return "Galaxy Note Edge";
            }
            case "v1awifi": 
            case "v1awifikx": 
            case "viennalte": 
            case "viennaltevzw": 
            case "v1a3g": 
            case "viennaltekx": 
            case "viennalteatt": {
                return "Galaxy Note Pro 12.2";
            }
            case "t0ltecmcc": 
            case "SC-02E": 
            case "t03gchn": 
            case "t0ltevzw": 
            case "t0ltetmo": 
            case "t03g": 
            case "t0ltespr": 
            case "t0ltelgt": 
            case "t0lteskt": 
            case "t03gcmcc": 
            case "t0lteatt": 
            case "t03gchnduos": 
            case "t0lteusc": 
            case "t03gctc": 
            case "t0lte": 
            case "t0ltektt": 
            case "t0ltedcm": 
            case "t03gcuduos": 
            case "t0ltecan": {
                return "Galaxy Note2";
            }
            case "SC-02F": 
            case "hltelgt": 
            case "hlteskt": 
            case "hltetmo": 
            case "hlte": 
            case "hltespr": 
            case "hlteatt": 
            case "htdlte": 
            case "SCL22": 
            case "hltektt": 
            case "hlteusc": 
            case "hltevzw": 
            case "ha3g": 
            case "hltecan": {
                return "Galaxy Note3";
            }
            case "hl3gds": 
            case "hllte": 
            case "frescoltektt": 
            case "hl3g": 
            case "frescolteskt": 
            case "frescoltelgt": {
                return "Galaxy Note3 Neo";
            }
            case "tre3caltelgt": 
            case "trltechn": 
            case "trlte": 
            case "tre3calteskt": 
            case "trlteusc": 
            case "tre3g": 
            case "treltektt": 
            case "trlteatt": 
            case "trltechnzh": 
            case "tre3caltektt": 
            case "treltelgt": 
            case "trltevzw": 
            case "trltespr": 
            case "trltetmo": 
            case "trelteskt": 
            case "trltecan": 
            case "trelte": 
            case "trhplte": {
                return "Galaxy Note4";
            }
            case "noblelteacg": 
            case "noblelteusc": 
            case "nobleltechn": 
            case "nobleltektt": 
            case "nobleltecmcc": 
            case "nobleltevzw": 
            case "noblelte": 
            case "nobleltetmo": 
            case "nobleltespr": 
            case "nobleltebmc": 
            case "nobleltehk": 
            case "nobleltelgt": 
            case "noblelteskt": 
            case "nobleltelra": 
            case "noblelteatt": {
                return "Galaxy Note5";
            }
            case "o5lte": 
            case "o5ltechn": {
                return "Galaxy On5";
            }
            case "o7ltechn": 
            case "o7lte": {
                return "Galaxy On7";
            }
            case "kyletdcmcc": 
            case "kylechn": 
            case "kyleichn": 
            case "kyleopen": {
                return "Galaxy S Duos";
            }
            case "kyleprods": {
                return "Galaxy S Duos2";
            }
            case "vivalto3gvn": {
                return "Galaxy S Duos3";
            }
            case "SHW-M250L": 
            case "GT-I9108": 
            case "SHW-M250K": 
            case "SCH-R760X": 
            case "SC-02C": 
            case "SGH-T989": 
            case "GT-I9100": 
            case "SHW-M250S": 
            case "GT-I9103": 
            case "GT-I9100M": 
            case "GT-I9100P": 
            case "GT-I9210T": 
            case "GT-I9100T": 
            case "SGH-I777": 
            case "t1cmcc": 
            case "SHV-E110S": 
            case "SGH-S959G": {
                return "Galaxy S2";
            }
            case "SC-03E": 
            case "d2xar": 
            case "d2mtr": 
            case "d2spi": 
            case "d2vmu": 
            case "d2att": 
            case "m0skt": 
            case "d2lterefreshspr": 
            case "d2tmo": 
            case "d2cri": 
            case "m0ctc": 
            case "d2dcm": 
            case "d2can": 
            case "c1lgt": 
            case "m0": 
            case "c1skt": 
            case "m3": 
            case "d2lteMetroPCS": 
            case "d2ltetmo": 
            case "d2usc": 
            case "m3dcm": 
            case "m0chn": 
            case "d2tfnvzw": 
            case "m0apt": 
            case "c1ktt": 
            case "d2tfnspr": 
            case "c1att": 
            case "d2vzw": 
            case "m0ctcduos": 
            case "d2spr": 
            case "m0cmcc": {
                return "Galaxy S3";
            }
            case "goldenltevzw": 
            case "goldenlteatt": 
            case "golden": 
            case "goldenve3g": 
            case "goldenltebmc": {
                return "Galaxy S3 Mini";
            }
            case "s3ve3g": 
            case "s3ve3gdsdd": 
            case "s3ve3gds": 
            case "s3ve3gdd": {
                return "Galaxy S3 Neo";
            }
            case "jalteskt": 
            case "jfltetmo": 
            case "ks01ltektt": 
            case "jfvelte": 
            case "jaltelgt": 
            case "jfltecri": 
            case "jfltelra": 
            case "jfltetfntmo": 
            case "jflterefreshspr": 
            case "jflteusc": 
            case "ks01ltelgt": 
            case "jflteaio": 
            case "jfltecan": 
            case "ks01lte": 
            case "jfltespr": 
            case "jfltevzwpp": 
            case "SC-04E": 
            case "jflte": 
            case "jfltevzw": 
            case "jfwifi": 
            case "jfltecsp": 
            case "jfltetfnatt": 
            case "jaltektt": 
            case "jflteatt": 
            case "jsglte": 
            case "ja3g": 
            case "ja3gduosctc": 
            case "jftdd": {
                return "Galaxy S4";
            }
            case "serranoltektt": 
            case "serranolteusc": 
            case "serrano3g": 
            case "serranove3g": 
            case "serranovolteatt": 
            case "serranoltelra": 
            case "serranods": 
            case "serranovelte": 
            case "serranoltebmc": 
            case "serranoltespr": 
            case "serranoltevzw": 
            case "serranoltekx": 
            case "serranolte": {
                return "Galaxy S4 Mini";
            }
            case "klte": 
            case "kltektt": 
            case "klteduoszn": 
            case "kltecan": 
            case "klteMetroPCS": 
            case "lentisltelgt": 
            case "lentislteskt": 
            case "klteacg": 
            case "klteusc": 
            case "SCL23": 
            case "klteaio": 
            case "kltelra": 
            case "klteskt": 
            case "lentisltektt": 
            case "klteatt": 
            case "kltevzw": 
            case "kltespr": 
            case "kwifi": 
            case "kltetmo": 
            case "k3g": 
            case "kltelgt": {
                return "Galaxy S5";
            }
            case "s5neoltecan": 
            case "s5neolte": {
                return "Galaxy S5 Neo";
            }
            case "zerofltechn": 
            case "zeroflteaio": 
            case "zeroflte": 
            case "zerofltektt": 
            case "zerofltemtr": 
            case "zeroflteatt": 
            case "zeroflteusc": 
            case "zeroflteacg": 
            case "zerofltelgt": 
            case "zeroflteskt": 
            case "zerofltebmc": 
            case "zerofltelra": 
            case "zerofltectc": 
            case "zerofltevzw": 
            case "zerofltespr": 
            case "zerofltetmo": 
            case "zerofltetfnvzw": {
                return "Galaxy S6";
            }
            case "zeroltektt": 
            case "zeroltechn": 
            case "zerolteacg": 
            case "zerolteusc": 
            case "zeroltevzw": 
            case "zeroltelra": 
            case "zerolteskt": 
            case "zeroltelgt": 
            case "SCV31": 
            case "zeroltebmc": 
            case "zeroltetmo": 
            case "zeroltespr": 
            case "zerolte": 
            case "zerolteatt": 
            case "404SC": {
                return "Galaxy S6 Edge";
            }
            case "zenltebmc": 
            case "zenltechn": 
            case "zenltelgt": 
            case "zenltetmo": 
            case "zenltekx": 
            case "zenltespr": 
            case "zenltevzw": 
            case "zenlte": 
            case "zenlteatt": 
            case "zenlteskt": 
            case "zenltektt": {
                return "Galaxy S6 Edge+";
            }
            case "SC-01D": 
            case "SHW-M380K": 
            case "GT-P7500": 
            case "SCH-I905": 
            case "GT-P7510": 
            case "SHW-M300W": 
            case "GT-P7503": 
            case "SGH-T859": 
            case "SHW-M380S": 
            case "GT-P7500D": 
            case "SHW-M380W": {
                return "Galaxy Tab 10.1";
            }
            case "GT-P6210": 
            case "SC-02D": 
            case "GT-P6201": 
            case "GT-P6200": 
            case "GT-P6211": 
            case "GT-P6200L": 
            case "SGH-T869": 
            case "SHW-M430W": {
                return "Galaxy Tab 7.0 Plus";
            }
            case "gtesqltespr": 
            case "gtesqlteusc": {
                return "Galaxy Tab E 8.0";
            }
            case "gtelwifi": 
            case "gtelwifiue": 
            case "gtelwifichn": 
            case "gtel3g": 
            case "gtelltevzw": {
                return "Galaxy Tab E 9.6";
            }
            case "degaswifiue": 
            case "403SC": 
            case "degasltespr": 
            case "degasveltechn": 
            case "degaswifiopenbnn": 
            case "degasvelte": 
            case "degaswifibmwzc": 
            case "degaswifidtv": 
            case "degasltevzw": 
            case "degaswifi": 
            case "degas3g": 
            case "degaslte": {
                return "Galaxy Tab4 7.0";
            }
            case "gvltexsp": 
            case "gvwifiue": 
            case "gvlteatt": 
            case "gvlte": {
                return "Galaxy View";
            }
            case "GT-S5368": 
            case "SCH-i509": 
            case "GT-S5360T": 
            case "SCH-I509": 
            case "GT-S5369": 
            case "GT-S5360": 
            case "GT-S5360L": 
            case "GT-S5360B": 
            case "GT-S5363": {
                return "Galaxy Y";
            }
            case "m7cdug": 
            case "m7cdtu": 
            case "m7": 
            case "m7wlv": 
            case "m7cdwg": 
            case "m7wls": {
                return "HTC One";
            }
            case "htc_mecul": 
            case "htc_mectl": 
            case "htc_mecwhl": 
            case "htc_mecdwg": {
                return "HTC One (E8)";
            }
            case "htc_m8wl": 
            case "htc_m8dwg": 
            case "htc_m8dug": 
            case "htc_m8": 
            case "htc_m8whl": {
                return "HTC One (M8)";
            }
            case "htc_hiaeuhl": 
            case "htc_hiaeul": 
            case "htc_hiaetuhl": 
            case "htc_hiaewhl": {
                return "HTC One A9";
            }
            case "htc_himauhl": 
            case "htc_himawhl": 
            case "htc_himaulatt": 
            case "htc_himaul": 
            case "htc_himawl": {
                return "HTC One M9";
            }
            case "villec2": 
            case "ville": {
                return "HTC One S";
            }
            case "hwH30-T10": 
            case "hwH30-U10": 
            case "hwhn3-u00": 
            case "hwhn3-u01": {
                return "Honor3";
            }
            case "acer_harleyfhd": 
            case "acer_harley": {
                return "Iconia Tab 10";
            }
            case "acer_apriliahd": 
            case "acer_aprilia": {
                return "Iconia Tab 7";
            }
            case "ducati2fhd": 
            case "ducati2hd": 
            case "ducati2hd3g": {
                return "Iconia Tab 8";
            }
            case "zee": {
                return "LG G Flex";
            }
            case "z2": {
                return "LG G Flex2";
            }
            case "g2": {
                return "LG G2";
            }
            case "g3": {
                return "LG G3";
            }
            case "p1": {
                return "LG G4";
            }
            case "c50ds": 
            case "c50n": 
            case "c50": {
                return "LG Leon 4G LTE";
            }
            case "cosmopolitan": {
                return "LG Optimus 3D";
            }
            case "geehdc": 
            case "geehrc": 
            case "geehrc4g": 
            case "geeb": {
                return "LG Optimus G";
            }
            case "geefhd4g": 
            case "geefhd": {
                return "LG Optimus G Pro";
            }
            case "u2": {
                return "LG Optimus L9";
            }
            case "A7-30GC": {
                return "Lenovo A7-30GC";
            }
            case "a1": {
                return "Liquid";
            }
            case "acer_e3n": 
            case "acer_e3": {
                return "Liquid E3";
            }
            case "acer_S55": {
                return "Liquid Jade";
            }
            case "acer_S56": {
                return "Liquid Jade S";
            }
            case "s3": {
                return "Liquid S3";
            }
            case "acer_ZXL": {
                return "Liquid Z5";
            }
            case "surnia_uds": 
            case "condor_cdma": 
            case "condor_umts": 
            case "condor_umtsds": 
            case "condor_udstv": 
            case "otus": 
            case "otus_ds": 
            case "surnia_cdma": 
            case "surnia_umts": 
            case "surnia_udstv": {
                return "MOTO E";
            }
            case "osprey_udstv": 
            case "osprey_umts": 
            case "thea_umtsds": 
            case "falcon_umts": 
            case "thea": 
            case "titan_umtsds": 
            case "peregrine": 
            case "osprey_cdma": 
            case "titan_udstv": 
            case "titan_umts": 
            case "osprey_uds": 
            case "osprey_ud2": 
            case "falcon_umtsds": 
            case "thea_ds": 
            case "falcon_cdma": 
            case "osprey_u2": {
                return "MOTO G";
            }
            case "ghost": 
            case "victara": {
                return "MOTO X";
            }
            case "HWCRR": {
                return "Mate S";
            }
            case "K013C": {
                return "MeMO Pad 7";
            }
            case "clark": {
                return "Moto X Style";
            }
            case "manta": {
                return "Nexus 10";
            }
            case "mako": {
                return "Nexus 4";
            }
            case "hammerhead": {
                return "Nexus 5";
            }
            case "bullhead": {
                return "Nexus 5X";
            }
            case "shamu": {
                return "Nexus 6";
            }
            case "angler": {
                return "Nexus 6P";
            }
            case "grouper": 
            case "tilapia": {
                return "Nexus 7 (2012)";
            }
            case "deb": 
            case "flo": {
                return "Nexus 7 (2013)";
            }
            case "flounder": {
                return "Nexus 9";
            }
            case "OnePlus": {
                return "OnePlus";
            }
            case "A0001": {
                return "OnePlus One";
            }
            case "OnePlus2": {
                return "OnePlus2";
            }
            case "p990": 
            case "p990_CIS-xxx": 
            case "star": 
            case "star_450-05": 
            case "su660": 
            case "p990_EUR-xx": 
            case "p990hN": 
            case "p999": 
            case "p990_262-xx": {
                return "Optimus 2X";
            }
            case "cosmo_450-05": 
            case "p920": 
            case "cosmo_EUR-XXX": 
            case "su760": 
            case "cosmo_MEA-XXX": {
                return "Optimus 3D";
            }
            case "cx2": {
                return "Optimus 3D MAX";
            }
            case "bproj_214-03": 
            case "bproj_EUR-XXX": 
            case "bproj_ARE-XXX": 
            case "black": 
            case "LGL85C": 
            case "bproj_302-220": 
            case "ku5900": 
            case "bproj_262-XXX": 
            case "blackg": 
            case "bproj_sea-xxx": 
            case "bproj_724-xxx": 
            case "lgp970": 
            case "bproj_334-020": {
                return "Optimus Black";
            }
            case "m4": {
                return "Optimus L5";
            }
            case "i_skt": 
            case "iproj": 
            case "lgp930": 
            case "i_dcm": 
            case "lgp935": 
            case "i_u": {
                return "Optimus LTE";
            }
            case "su370": 
            case "ku3700": 
            case "thunder_kor-05": 
            case "lu3700": 
            case "thunderc": 
            case "thunder_kor-08": {
                return "Optimus One";
            }
            case "l06c": 
            case "v901ar": 
            case "v905r": 
            case "v900": 
            case "v900asia": 
            case "v901tr": 
            case "v909mkt": 
            case "v909": 
            case "v901kr": {
                return "Optimus Pad";
            }
            case "thunderbird": 
            case "LW": 
            case "Venue7": {
                return "Venue 7";
            }
            case "BB": 
            case "yellowtail": 
            case "Venue8": {
                return "Venue 8";
            }
            case "wifi_hubble": 
            case "umts_hubble": 
            case "umts_everest": 
            case "stingray": 
            case "wingray": {
                return "XOOM";
            }
            case "D2104": 
            case "D2105": {
                return "Xperia E1 dual";
            }
            case "D2203": 
            case "D2202": 
            case "D2243": 
            case "D2206": {
                return "Xperia E3";
            }
            case "E5653": 
            case "E5606": 
            case "E5603": {
                return "Xperia M5";
            }
            case "E5643": 
            case "E5633": 
            case "E5663": {
                return "Xperia M5 Dual";
            }
            case "SO-02D": 
            case "LT26i": {
                return "Xperia S";
            }
            case "D5316": 
            case "D5303": 
            case "D5322": 
            case "D5316N": 
            case "D5306": {
                return "Xperia T2 Ultra";
            }
            case "txs03": {
                return "Xperia Tablet S";
            }
            case "SO-03E": 
            case "SGP312": 
            case "SGP311": 
            case "SGP321": 
            case "SGP341": 
            case "SGP351": {
                return "Xperia Tablet Z";
            }
            case "D6503": 
            case "D6502": 
            case "SO-03F": 
            case "D6543": {
                return "Xperia Z2";
            }
            case "D6603": 
            case "D6646": 
            case "401SO": 
            case "SOL26": 
            case "D6643": 
            case "D6653": 
            case "SO-01G": 
            case "leo": 
            case "D6616": {
                return "Xperia Z3";
            }
            case "402SO": 
            case "SO-03G": 
            case "SOV31": {
                return "Xperia Z4";
            }
            case "SO-02H": 
            case "E5823": 
            case "E5803": {
                return "Xperia Z5 Compact";
            }
            case "ASUS_T00J": 
            case "ASUS_T00F": {
                return "ZenFone 5";
            }
        }
        return fallback;
    }

    public static DeviceInfo getDeviceInfo(Context context) {
        return DeviceName.getDeviceInfo(context.getApplicationContext(), Build.DEVICE, Build.MODEL);
    }

    private static DeviceInfo getDeviceInfo(Context context, String codename, String model) {
        String key;
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_NAME, 0);
        String savedJson = prefs.getString(key = String.format("%s:%s", codename, model), null);
        if (savedJson != null) {
            try {
                return new DeviceInfo(new JSONObject(savedJson));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        int ret = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        boolean isConnectedToNetwork = false;
        if (ret == 0) {
            ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                isConnectedToNetwork = true;
            }
        } else {
            isConnectedToNetwork = true;
        }
        if (isConnectedToNetwork) {
            try {
                String url = String.format(DEVICE_JSON_URL, codename);
                String jsonString = DeviceName.downloadJson(url);
                JSONArray jsonArray = new JSONArray(jsonString);
                int len = jsonArray.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject json = jsonArray.getJSONObject(i);
                    DeviceInfo info = new DeviceInfo(json);
                    if (!codename.equals(info.codename) || !model.equals(info.model)) continue;
                    SharedPreferences.Editor editor = prefs.edit();
                    editor.putString(key, json.toString());
                    if (Build.VERSION.SDK_INT >= 9) {
                        editor.apply();
                    } else {
                        editor.commit();
                    }
                    return info;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (codename.equals(Build.DEVICE) && model.equals(Build.MODEL)) {
            return new DeviceInfo(Build.MANUFACTURER, DeviceName.getDeviceName(), codename, model);
        }
        return new DeviceInfo(null, null, codename, model);
    }

    private static String capitalize(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] arr = str.toCharArray();
        boolean capitalizeNext = true;
        String phrase = "";
        for (char c : arr) {
            if (capitalizeNext && Character.isLetter(c)) {
                phrase = phrase + Character.toUpperCase(c);
                capitalizeNext = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                capitalizeNext = true;
            }
            phrase = phrase + c;
        }
        return phrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadJson(String myurl) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = null;){
            URL url = new URL(myurl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                String line;
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
            String string = sb.toString();
            return string;
        }
    }

    public static final class DeviceInfo {
        public final String manufacturer;
        public final String marketName;
        public final String codename;
        public final String model;

        public DeviceInfo(String manufacturer, String marketName, String codename, String model) {
            this.manufacturer = manufacturer;
            this.marketName = marketName;
            this.codename = codename;
            this.model = model;
        }

        private DeviceInfo(JSONObject jsonObject) throws JSONException {
            this.manufacturer = jsonObject.getString("manufacturer");
            this.marketName = jsonObject.getString("market_name");
            this.codename = jsonObject.getString("codename");
            this.model = jsonObject.getString("model");
        }

        public String getName() {
            if (!TextUtils.isEmpty((CharSequence)this.marketName)) {
                return this.marketName;
            }
            return DeviceName.capitalize(this.model);
        }
    }

    public static interface Callback {
        public void onFinished(DeviceInfo var1, Exception var2);
    }

    public static final class Request {
        private final Context context;
        private final Handler handler;
        private String codename;
        private String model;

        private Request(Context ctx) {
            this.context = ctx;
            this.handler = new Handler(ctx.getMainLooper());
            this.codename = Build.DEVICE;
            this.model = Build.MODEL;
        }

        public Request setCodename(String codename) {
            this.codename = codename;
            return this;
        }

        public Request setModel(String model) {
            this.model = model;
            return this;
        }

        public void request(Callback callback) {
            GetDeviceRunnable runnable = new GetDeviceRunnable(callback);
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }

        private final class GetDeviceRunnable
        implements Runnable {
            private final Callback callback;
            private DeviceInfo deviceInfo;
            private Exception error;

            public GetDeviceRunnable(Callback callback) {
                this.callback = callback;
            }

            @Override
            public void run() {
                try {
                    this.deviceInfo = DeviceName.getDeviceInfo(Request.this.context, Request.this.codename, Request.this.model);
                }
                catch (Exception e) {
                    this.error = e;
                }
                Request.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        GetDeviceRunnable.this.callback.onFinished(GetDeviceRunnable.this.deviceInfo, GetDeviceRunnable.this.error);
                    }
                });
            }
        }
    }
}

