/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.jmx.JamonJmxBeanProperty;
import com.jamonapi.jmx.JamonJmxBeanPropertyDefault;
import com.jamonapi.jmx.JmxUtils;
import com.jamonapi.jmx.MonitorDeltaMXBeanImp;
import com.jamonapi.jmx.MonitorDeltaMsMXBeanImp;
import com.jamonapi.jmx.MonitorMXBean;
import com.jamonapi.jmx.MonitorMXBeanImp;
import com.jamonapi.jmx.MonitorMsMXBeanImp;
import com.jamonapi.utils.Misc;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class MonitorMXBeanFactory {
    static List<JamonJmxBeanProperty> getJmxBeanProperties(String propertyValue) {
        if (propertyValue == null || propertyValue.trim().equals("")) {
            throw new RuntimeException("The passed in propertyValue can not be empty or null");
        }
        String[] propsArray = Misc.trim(propertyValue.split(","));
        if (propsArray.length < 2) {
            throw new RuntimeException("Both JAMon monitor label and units are required to create a Jmx bean: " + propertyValue);
        }
        String name = null;
        name = MonitorMXBeanFactory.isEven(propsArray.length) ? propsArray[0] : propsArray[propsArray.length - 1];
        ArrayList<JamonJmxBeanProperty> jmxProperties = new ArrayList<JamonJmxBeanProperty>();
        int elements = propsArray.length / 2;
        for (int i = 0; i < elements; ++i) {
            int labelIndex = i * 2;
            int unitsIndex = labelIndex + 1;
            jmxProperties.add(new JamonJmxBeanPropertyDefault(propsArray[labelIndex], propsArray[unitsIndex], name));
        }
        return jmxProperties;
    }

    static boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static MonitorMXBean create(String propertyValue) {
        List<JamonJmxBeanProperty> jmxProperties = MonitorMXBeanFactory.getJmxBeanProperties(propertyValue);
        String units = jmxProperties.get(0).getUnits();
        MonitorMXBeanImp bean = null;
        bean = "ms.".equals(units) ? new MonitorMsMXBeanImp(jmxProperties) : new MonitorMXBeanImp(jmxProperties);
        return bean;
    }

    @Deprecated
    static MonitorMXBean create(String label, String units, String name) {
        if (name == null || "".equals(name.trim())) {
            name = label;
        }
        return MonitorMXBeanFactory.create(label + ", " + units + ", " + name);
    }

    public static MonitorMXBean createDelta(String propertyValue) {
        List<JamonJmxBeanProperty> jmxProperties = MonitorMXBeanFactory.getJmxBeanProperties(propertyValue);
        String units = jmxProperties.get(0).getUnits();
        MonitorDeltaMXBeanImp bean = null;
        bean = "ms.".equals(units) ? new MonitorDeltaMsMXBeanImp(jmxProperties) : new MonitorDeltaMXBeanImp(jmxProperties);
        return bean;
    }

    @Deprecated
    static MonitorMXBean createDelta(String label, String units, String name) {
        if (name == null || "".equals(name.trim())) {
            name = label;
        }
        return MonitorMXBeanFactory.createDelta(label + ", " + units + ", " + name);
    }

    public static ObjectName getObjectName(MonitorMXBean beanImp) {
        return JmxUtils.getObjectName(beanImp.getClass().getPackage().getName() + ":type=current,name=" + beanImp.getName());
    }

    public static ObjectName getDeltaObjectName(MonitorMXBean beanImp) {
        return JmxUtils.getObjectName(MonitorMXBean.class.getPackage().getName() + ":type=delta,name=" + beanImp.getName());
    }
}

