/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.JAMonDetailValue;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.MonitorImp;
import com.jamonapi.Range;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.Misc;
import com.jamonapi.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MonitorComposite
extends Monitor
implements DetailData {
    private static final long serialVersionUID = 279L;
    public static final String LOCAL = "local";
    private final Monitor[] monitors;
    private final int numRows;
    private static final int TYPICAL_NUM_CHILDREN = 200;
    private Map<MonKey, Monitor> map;
    private Date dateCreated;
    private String instanceName = "local";

    public MonitorComposite(Monitor[] monitors) {
        this.monitors = monitors;
        this.numRows = monitors == null ? 0 : monitors.length;
        this.initializeForLookUps();
        this.dateCreated = new Date();
    }

    private void initializeForLookUps() {
        this.map = new HashMap<MonKey, Monitor>();
        if (this.monitors != null) {
            for (Monitor mon : this.monitors) {
                this.map.put(mon.getMonKey(), mon);
            }
        }
    }

    MonitorComposite() {
        this((Monitor[])null);
    }

    public Monitor[] getMonitors() {
        return this.monitors;
    }

    private Monitor[] getMonitorsWithUnits(String units) {
        if (this.monitors == null || units == null) {
            return null;
        }
        if ("AllMonitors".equalsIgnoreCase(units)) {
            return this.monitors;
        }
        int size = this.monitors.length;
        ArrayList<Monitor> rows = new ArrayList<Monitor>(this.monitors.length);
        for (int i = 0; i < size; ++i) {
            if (!units.equalsIgnoreCase(this.monitors[i].getMonKey().getRangeKey())) continue;
            rows.add(this.monitors[i]);
        }
        if (rows.size() == 0) {
            return null;
        }
        return rows.toArray(new MonitorImp[0]);
    }

    public Collection<String> getDistinctUnits() {
        TreeSet<String> units = new TreeSet<String>();
        int size = this.monitors.length;
        for (int i = 0; i < size; ++i) {
            units.add(this.monitors[i].getMonKey().getRangeKey());
        }
        return units;
    }

    public MonitorComposite filterByUnits(String units) {
        return new MonitorComposite(this.getMonitorsWithUnits(units)).setInstanceName(this.getInstanceName()).setDateCreated(this.getDateCreated());
    }

    public boolean exists(MonKey key) {
        return this.map.containsKey(key);
    }

    public Monitor getMonitor(MonKey key) {
        return this.map.get(key);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public MonitorComposite setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public boolean isLocalInstance() {
        return LOCAL.equalsIgnoreCase(this.instanceName);
    }

    public static MonitorComposite getMonitors(String[][] labels) {
        int numRows = labels == null ? 0 : labels.length;
        int numCols = labels[0] == null ? 0 : labels[0].length;
        Monitor[] monArray = new Monitor[numRows];
        for (int i = 0; i < numRows; ++i) {
            MonKeyImp key = null;
            if (numCols == 2) {
                key = new MonKeyImp(labels[i][0], labels[i][1]);
            } else if (numCols == 3) {
                key = new MonKeyImp(labels[i][0], labels[i][1], labels[i][2]);
            }
            monArray[i] = MonitorFactory.getMonitor(key);
        }
        return new MonitorComposite(monArray);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String[] getBasicHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getBasicHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public String[] getHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    public String[] getDisplayHeader() {
        ArrayList header = new ArrayList();
        if (this.hasData()) {
            this.getFirstMon().getDisplayHeader(header);
            return header.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public Object[][] getData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getRowData((MonitorImp)this.monitors[i]);
        }
        return data;
    }

    public Object[][] getBasicData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getBasicRowData((MonitorImp)this.monitors[i]);
        }
        return data;
    }

    public Object[][] getDisplayData() {
        if (!this.hasData()) {
            return null;
        }
        Object[][] data = new Object[this.getNumRows()][];
        for (int i = 0; i < this.numRows; ++i) {
            data[i] = this.getRowDisplayData((MonitorImp)this.monitors[i]);
        }
        return data;
    }

    public String getReport() {
        return this.getReport(0, "asc");
    }

    public String getReport(int sortCol, String sortOrder) {
        int i;
        boolean LABEL = true;
        if (!this.hasData()) {
            return "";
        }
        String[] header = this.getBasicHeader();
        Object[][] data = Misc.sort(this.getBasicData(), sortCol, sortOrder);
        int rows = data.length;
        int cols = header.length;
        StringBuffer html = new StringBuffer(100000);
        html.append("\n<table border='1' rules='all'>\n");
        for (i = 0; i < cols; ++i) {
            html.append("<th>" + header[i] + "</th>");
        }
        html.append("<th>" + header[1] + "</th>");
        html.append("\n");
        for (i = 0; i < rows; ++i) {
            html.append("<tr>");
            for (int j = 0; j < cols; ++j) {
                html.append("<td>" + data[i][j] + "</td>");
            }
            html.append("<td>" + data[i][1] + "</td>");
            html.append("</tr>\n");
        }
        html.append("</table>");
        return html.toString();
    }

    public boolean hasData() {
        return this.getNumRows() != 0;
    }

    private Object[] getRowData(MonitorImp mon) {
        ArrayList row = new ArrayList(200);
        mon.getRowData(row);
        return row.toArray();
    }

    private Object[] getBasicRowData(MonitorImp mon) {
        ArrayList row = new ArrayList();
        mon.getBasicRowData(row);
        return row.toArray();
    }

    private Object[] getRowDisplayData(MonitorImp mon) {
        ArrayList row = new ArrayList(200);
        mon.getRowDisplayData(row);
        return row.toArray();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].reset();
        }
    }

    @Override
    public void disable() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].disable();
        }
    }

    @Override
    public void enable() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].enable();
        }
    }

    @Override
    public double getActive() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getActive();
        }
        return value;
    }

    @Override
    public double getAvg() {
        double hits = this.getHits();
        double total = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            total += this.monitors[i].getTotal();
        }
        if (hits == 0.0) {
            return 0.0;
        }
        return total / hits;
    }

    @Override
    public double getAvgActive() {
        double weightedActive = 0.0;
        double totalHits = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double hits = this.monitors[i].getHits();
            weightedActive = hits * this.monitors[i].getAvgActive();
            totalHits += hits;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedActive / totalHits;
    }

    @Override
    public Date getFirstAccess() {
        Date firstAccess = null;
        for (int i = 0; i < this.numRows; ++i) {
            Date thisDate = this.monitors[i].getFirstAccess();
            if (firstAccess != null && thisDate.compareTo(firstAccess) >= 0) continue;
            firstAccess = thisDate;
        }
        return firstAccess;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public MonitorComposite setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @Override
    public double getHits() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getHits();
        }
        return value;
    }

    @Override
    public MonKey getMonKey() {
        if (!this.hasData()) {
            return null;
        }
        return this.getFirstMon().getMonKey();
    }

    @Override
    public Date getLastAccess() {
        Date lastAccess = null;
        for (int i = 0; i < this.numRows; ++i) {
            Date thisDate = this.monitors[i].getLastAccess();
            if (lastAccess != null && thisDate.compareTo(lastAccess) <= 0) continue;
            lastAccess = thisDate;
        }
        return lastAccess;
    }

    @Override
    public double getLastValue() {
        Date date = this.getLastAccess();
        for (int i = 0; i < this.numRows; ++i) {
            if (date.compareTo(this.monitors[i].getLastAccess()) < 0) continue;
            return this.monitors[i].getLastValue();
        }
        return 0.0;
    }

    @Override
    public double getMax() {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMax = this.monitors[i].getMax();
            if (!(thisMax > max)) continue;
            max = thisMax;
        }
        return max;
    }

    @Override
    public double getMaxActive() {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMax = this.monitors[i].getMaxActive();
            if (!(thisMax > max)) continue;
            max = thisMax;
        }
        return max;
    }

    @Override
    public double getMin() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.numRows; ++i) {
            double thisMin = this.monitors[i].getMin();
            if (!(thisMin < min)) continue;
            min = thisMin;
        }
        return min;
    }

    @Override
    public Range getRange() {
        return null;
    }

    @Override
    public double getStdDev() {
        double weightedStdDev = 0.0;
        double totalHits = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double hits = this.monitors[i].getHits();
            weightedStdDev = hits * this.monitors[i].getStdDev();
            totalHits += hits;
        }
        if (totalHits == 0.0) {
            return 0.0;
        }
        return weightedStdDev / totalHits;
    }

    @Override
    public double getTotal() {
        double value = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            value += this.monitors[i].getTotal();
        }
        return value;
    }

    @Override
    public boolean isEnabled() {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.monitors[i].isEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrimary() {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.monitors[i].isPrimary()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setActive(0.0);
        }
    }

    @Override
    public void setFirstAccess(Date date) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setFirstAccess(date);
        }
    }

    @Override
    public void setHits(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setHits(value);
        }
    }

    @Override
    public void setLastAccess(Date date) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setLastAccess(date);
        }
    }

    @Override
    public void setLastValue(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setLastValue(value);
        }
    }

    @Override
    public void setMax(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMax(value);
        }
    }

    @Override
    public void setMaxActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMaxActive(value);
        }
    }

    @Override
    public void setMin(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setMin(value);
        }
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setPrimary(isPrimary);
        }
    }

    @Override
    public void setTotal(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setTotal(value);
        }
    }

    @Override
    public void setTotalActive(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setTotalActive(value);
        }
    }

    @Override
    public Monitor start() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].start();
        }
        return this;
    }

    @Override
    public Monitor stop() {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].stop();
        }
        return this;
    }

    private MonitorImp getFirstMon() {
        return (MonitorImp)this.monitors[0];
    }

    @Override
    public Monitor add(double value) {
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].add(value);
        }
        return this;
    }

    @Override
    public boolean hasListeners() {
        if (super.hasListeners()) {
            return true;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (!this.monitors[i].hasListeners()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JAMonDetailValue getJAMonDetailRow() {
        return JAMonDetailValue.NULL_VALUE;
    }

    @Override
    public void setActivityTracking(boolean trackActivity) {
        super.setActivityTracking(trackActivity);
        for (int i = 0; i < this.numRows; ++i) {
            this.monitors[i].setActivityTracking(trackActivity);
        }
    }

    public MonitorComposite copy() {
        return (MonitorComposite)SerializationUtils.deepCopy(this);
    }
}

