/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.http.HttpMon;
import com.jamonapi.http.HttpMonFactory;
import com.jamonapi.http.HttpMonItem;
import com.jamonapi.utils.Misc;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

final class HttpMonRequest
implements HttpMon {
    private static final String EXCEPTION_ATTR = "javax.servlet.error.exception";
    private final Object request;
    private final Object response;
    private final HttpMonFactory httpMonFactory;
    private Monitor[] timeMons;
    private int timeMonIndex = 0;
    private String keyReadyURI;
    private String detailLabel;
    private String stackTrace;
    private Throwable requestException;

    HttpMonRequest(Object request, Object response, HttpMonFactory httpMonFactory) {
        this.request = request;
        this.response = response;
        this.httpMonFactory = httpMonFactory;
        this.timeMons = httpMonFactory.getNumTimeMons() > 0 ? new Monitor[httpMonFactory.getNumTimeMons()] : null;
        this.detailLabel = this.getRequestURI();
    }

    public HttpMon start() {
        this.timeMonIndex = 0;
        Iterator iter = this.iter();
        while (iter.hasNext()) {
            HttpMonItem monItem = (HttpMonItem)iter.next();
            monItem.start(this);
        }
        return this;
    }

    public void stop() {
        this.timeMonIndex = 0;
        this.setException();
        Iterator iter = this.iter();
        while (iter.hasNext()) {
            HttpMonItem monItem = (HttpMonItem)iter.next();
            monItem.stop(this);
        }
        if (this.stackTrace != null) {
            this.changeDetails();
        }
    }

    private void changeDetails() {
        int len = this.timeMons == null ? 0 : this.timeMons.length;
        for (int i = 0; i < len; ++i) {
            this.timeMons[i].getMonKey().setDetails(this.getDetailLabel());
        }
    }

    private Iterator iter() {
        return this.httpMonFactory.iter();
    }

    public String getDetailLabel() {
        if (this.stackTrace == null || "".equalsIgnoreCase(this.stackTrace)) {
            return this.getRequestURI();
        }
        return new StringBuffer(this.getRequestURI()).append("\n").append(this.stackTrace).toString();
    }

    public Throwable getException() {
        return this.requestException;
    }

    public void setException(Throwable t) {
        this.requestException = t;
    }

    private void setException() {
        Object exc;
        if (this.requestException == null && this.request instanceof HttpServletRequest && (exc = ((HttpServletRequest)this.request).getAttribute(EXCEPTION_ATTR)) instanceof Throwable) {
            this.setException((Throwable)exc);
        }
        if (this.requestException != null) {
            StringBuffer trace = new StringBuffer("stackTrace=").append(Misc.getExceptionTrace(this.requestException));
            if (this.requestException instanceof ServletException && ((ServletException)this.requestException).getRootCause() != null) {
                trace.append("\nrootCause=").append(Misc.getExceptionTrace(((ServletException)this.requestException).getRootCause()));
            }
            this.setStackTrace(trace.toString());
            String label = this.getLabelPrefix() + ".ServletException";
            MonitorFactory.add(new MonKeyImp(label, this.getDetailLabel(), "Exception"), 1.0);
            MonitorFactory.add(new MonKeyImp("com.jamonapi.Exceptions", this.getDetailLabel(), "Exception"), 1.0);
        }
    }

    public void throwException(Throwable t) throws IOException, ServletException {
        this.setException();
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new ServletException(t);
    }

    String getRequestURI() {
        if (this.detailLabel != null) {
            return this.detailLabel;
        }
        if (this.request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.request).getRequestURI();
        }
        return "";
    }

    String getKeyReadyURI() {
        if (this.keyReadyURI == null) {
            this.keyReadyURI = HttpMonRequest.removeHttpParams(this.getRequestURI());
        }
        return this.keyReadyURI;
    }

    String getContextPath() {
        if (this.request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.request).getContextPath();
        }
        return "";
    }

    void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    String getLabelPrefix() {
        return this.httpMonFactory.getLabelPrefix();
    }

    boolean getIgnoreHttpParams() {
        return this.httpMonFactory.getIgnoreHttpParams();
    }

    boolean isEnabled() {
        return this.httpMonFactory.getEnabled();
    }

    int getSize() {
        return this.httpMonFactory.getSize();
    }

    Object getRequest() {
        return this.request;
    }

    Object getResponse() {
        return this.response;
    }

    void setTimeMon(Monitor mon) {
        if (this.timeMons != null && this.timeMonIndex < this.timeMons.length) {
            this.timeMons[this.timeMonIndex++] = mon;
        }
    }

    void stopTimeMon() {
        if (this.timeMons != null && this.timeMonIndex < this.timeMons.length) {
            this.timeMons[this.timeMonIndex++].stop();
        }
    }

    Monitor getNextTimeMon() {
        if (this.timeMons != null && this.timeMonIndex < this.timeMons.length) {
            return this.timeMons[this.timeMonIndex++];
        }
        return null;
    }

    private static String removeHttpParams(Object url) {
        if (url == null) {
            return null;
        }
        String urlStr = url.toString();
        int paramIndex = urlStr.indexOf(";");
        if (paramIndex == -1) {
            return urlStr;
        }
        return urlStr.substring(0, paramIndex);
    }
}

