/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.http.HttpMon;
import com.jamonapi.http.HttpMonItem;
import com.jamonapi.http.HttpMonManage;
import com.jamonapi.http.HttpMonNull;
import com.jamonapi.http.HttpMonRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HttpMonFactory
implements HttpMonManage {
    private static final String DEFAULT_SUMMARY = "request.getRequestURI().ms as allPages, request.getRequestURI().value.ms as page";
    private String jamonSummaryLabels = "default";
    private Collection httpMonItemsHolder = new ArrayList();
    private boolean ignoreHttpParams = true;
    private String labelPrefix;
    private boolean enabled = true;
    private int numTimeMons = 0;
    private int size = 5000;
    private static final HttpMon NULL_HTTP_MON = new HttpMonNull();

    public HttpMonFactory(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setSummaryLabels(String jamonSummaryLabels) {
        this.jamonSummaryLabels = "";
        this.httpMonItemsHolder = new ArrayList();
        this.numTimeMons = 0;
        if (jamonSummaryLabels == null) {
            return;
        }
        jamonSummaryLabels = jamonSummaryLabels.replaceAll("(?i)demo", HttpMonFactory.getDemoLabels());
        jamonSummaryLabels = HttpMonFactory.replaceDefault(jamonSummaryLabels, DEFAULT_SUMMARY);
        String[] summaryLabelsArr = this.split(jamonSummaryLabels);
        for (int i = 0; i < summaryLabelsArr.length; ++i) {
            this.addSummaryLabel(summaryLabelsArr[i]);
        }
    }

    public static String getDemoLabels() {
        String demoStr = "";
        demoStr = demoStr + HttpMonFactory.getDemoLabel("response.getBufferSize()", "bytes");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("response.getCharacterEncoding()", "charEncoding");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("response.getContentCount()", "bytes");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("response.getContentType()", "contentType");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("response.getLocale()", "locale");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getAuthType()", "authType");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getCharacterEncoding()", "charEncoding");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getContentLength()", "bytes");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getContentType()", "contentType");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getContextPath()", "path");
        demoStr = demoStr + "request.getContextPath().value.ms, ";
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getLocalAddr()", "ip");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getLocale()", "locale");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getLocalName()", "localName");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getLocalPort()", "port");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getMethod()", "httpMethod");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getPathInfo()", "path");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getPathTranslated()", "path");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getProtocol()", "protocol");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getQueryString()", "queryStr");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRemoteAddr()", "ip");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRemoteHost()", "ip");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRemotePort()", "port");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRemoteUser()", "user");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRequestedSessionId()", "sessionid");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRequestURI()", "ms");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getRequestURL()", "ms");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getScheme()", "scheme");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getServerName()", "serverName");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getServerPort()", "port");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getServletPath()", "path");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.getUserPrincipal()", "user");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.isRequestedSessionIdFromCookie()", "sessionCookie");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.isRequestedSessionIdValid()", "sessionValid");
        demoStr = demoStr + HttpMonFactory.getDemoLabel("request.isSecure()", "secure");
        demoStr = demoStr + "request.getScheme().ms as schemeAlias";
        return demoStr;
    }

    private static String getDemoLabel(String label, String units) {
        String str = label + "." + units;
        str = str + ", " + label + ".value." + units;
        str = str + ", " + label + ".contextpath.value." + units;
        str = str + ", " + label + ".value.contextpath." + units;
        str = str + ", " + label + ".value.url." + units + ",";
        return str;
    }

    public void setSummaryLabels(String summaryLabel, String defaultString) {
        summaryLabel = HttpMonFactory.replaceDefault(summaryLabel, defaultString);
        this.setSummaryLabels(summaryLabel);
    }

    static String replaceDefault(String summaryLabel, String defaultString) {
        return summaryLabel.replaceAll("(?i)default", defaultString);
    }

    public void addSummaryLabel(String jamonSummaryLabel) {
        if (this.httpMonItemsHolder != null) {
            HttpMonItem monItem = this.createHttpMonItem(jamonSummaryLabel.trim());
            this.httpMonItemsHolder.add(monItem);
            if (!"".equals(this.jamonSummaryLabels)) {
                this.jamonSummaryLabels = this.jamonSummaryLabels + ", ";
            }
            this.jamonSummaryLabels = this.jamonSummaryLabels + jamonSummaryLabel;
            if (monItem.isTimeMon()) {
                ++this.numTimeMons;
            }
        }
    }

    int getNumRows() {
        return this.httpMonItemsHolder.size();
    }

    int getNumTimeMons() {
        return this.numTimeMons;
    }

    Iterator iter() {
        return this.httpMonItemsHolder.iterator();
    }

    public String getSummaryLabels() {
        return this.jamonSummaryLabels;
    }

    public boolean getIgnoreHttpParams() {
        return this.ignoreHttpParams;
    }

    public void setIgnoreHttpParams(boolean ignoreHttpParams) {
        this.ignoreHttpParams = ignoreHttpParams;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    private String[] split(String str) {
        return str == null ? null : str.split(",");
    }

    public HttpMon getMon(Object request, Object response) {
        if (!this.enabled || this.jamonSummaryLabels == null) {
            return NULL_HTTP_MON;
        }
        return new HttpMonRequest(request, response, this);
    }

    public HttpMon start(Object request, Object response) {
        return this.getMon(request, response).start();
    }

    HttpMonItem createHttpMonItem(String label) {
        return new HttpMonItem(label, this);
    }
}

