/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CopyJAMonListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.Monitor;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.BufferListDetailData;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.ToArray;
import java.util.ArrayList;
import java.util.List;

public class JAMonBufferListener
implements JAMonListener,
CopyJAMonListener {
    private BufferList list;
    private String name;
    static final String[] DEFAULT_HEADER = JAMonBufferListener.getDefaultHeaderInfo().getHeader();
    static final int VALUE_COL = JAMonBufferListener.getDefaultHeaderInfo().getLastValueIndex();
    static final int DATE_COL = JAMonBufferListener.getDefaultHeaderInfo().getDateIndex();

    public JAMonBufferListener() {
        this("JAMonBufferListener");
    }

    public JAMonBufferListener(String name) {
        this(name, new BufferList(DEFAULT_HEADER, 50));
    }

    public JAMonBufferListener(String name, BufferList list) {
        this.name = name;
        this.list = list;
    }

    public void processEvent(Monitor mon) {
        this.list.addRow(mon.getJAMonDetailRow());
    }

    public void addRow(ToArray row) {
        this.list.addRow(row);
    }

    public void addRow(Object[] row) {
        this.list.addRow(row);
    }

    public BufferList getBufferList() {
        return this.list;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JAMonListener copy() {
        return new JAMonBufferListener(this.getName(), this.list.copy());
    }

    public DetailData getDetailData() {
        return new BufferListDetailData(this.list);
    }

    public int getRowCount() {
        return this.list.getRowCount();
    }

    public boolean hasData() {
        return this.list.hasData();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static HeaderInfo getDefaultHeaderInfo() {
        return JAMonBufferListener.getHeaderInfo(new String[]{"Label"});
    }

    public static HeaderInfo getHeaderInfo(String[] firstPart) {
        return new HeaderInfo(firstPart);
    }

    public static class HeaderInfo {
        private String[] header;
        private int lastValueIndex;
        private int dateIndex;
        private int activeIndex;

        public HeaderInfo(String[] firstPart) {
            this.header = HeaderInfo.makeHeader(firstPart);
            for (int i = 0; i < this.header.length; ++i) {
                if ("LastValue".equalsIgnoreCase(this.header[i])) {
                    this.lastValueIndex = i;
                    continue;
                }
                if ("Date".equalsIgnoreCase(this.header[i])) {
                    this.dateIndex = i;
                    continue;
                }
                if (!"Active".equalsIgnoreCase(this.header[i])) continue;
                this.activeIndex = i;
            }
        }

        public String[] getHeader() {
            return this.header;
        }

        public int getLastValueIndex() {
            return this.lastValueIndex;
        }

        public int getDateIndex() {
            return this.dateIndex;
        }

        public int getActiveIndex() {
            return this.activeIndex;
        }

        public int getNumCols() {
            return this.header.length;
        }

        public Object[] getData(Monitor mon) {
            Object[] retData = new Object[this.header.length];
            retData[this.lastValueIndex] = new Double(mon.getLastValue());
            retData[this.activeIndex] = new Double(mon.getActive());
            retData[this.dateIndex] = mon.getLastAccess();
            return retData;
        }

        public Object[] getData(List dataList, Monitor mon) {
            dataList.add(new Double(mon.getLastValue()));
            dataList.add(new Double(mon.getActive()));
            dataList.add(mon.getLastAccess());
            return dataList.toArray();
        }

        static String[] makeHeader(String[] firstPart) {
            int firstPartCount = firstPart == null ? 0 : firstPart.length;
            ArrayList<String> newHeader = new ArrayList<String>();
            for (int i = 0; i < firstPartCount; ++i) {
                newHeader.add(firstPart[i]);
            }
            String[] lastPart = new String[]{"LastValue", "Active", "Date"};
            for (int i = 0; i < lastPart.length; ++i) {
                newHeader.add(lastPart[i]);
            }
            return newHeader.toArray(new String[0]);
        }
    }
}

