package com.jamonapi.utils;

/** Difficult to group Utilities **/

public class Misc extends java.lang.Object {
    /** Returns an Objects ClassName minus the package name
     *  Sample Call:
     *      String className=Misc.getClassName("My Object"); // returns "String"
     **/
    public static String getClassName(Object object) {
        String className = (object==null ? "null" : object.getClass().getName());  // gov.gsa.fss.fim.Misc
        return className.substring(className.lastIndexOf(".")+1);    // Misc
    }
    
    
    public static void isObjectString(Object arg) {
        if (!(arg instanceof String))
            throw new IllegalArgumentException("Illegal Argument exception: This object must be of type String.");
    }
    
    /** Sort a 2 dimensional array based on 1 columns data in either ascending or descending order.
     *  array - Array to be sorted
     *  sortCol - column to sort by
     *  sortOrder - sort the column in ascending or descending order.  Valid arguments are "asc" and "desc".
     **/
    public static Object[][] sort(Object[][] array, int sortCol, String sortOrder) {
        ArraySorter sorter=new ArraySorter(array, sortCol, sortOrder);
        return sorter.sort();
    }
}

