package com.jamonapi.utils;

/**
 * A CompositeNode works with NodeTrees and LeafNodes to create heirarchical object trees.  An example is a file system where directories
 * can be viewed LeafNodes and directories can be viewed as CompositeNodes.  TreeNodes can be viewed as the top level of the tree structures.
 *
 **/
public interface CompositeNode {
    /** Return the NodeTrees root CompositeNode i.e. the root of the heirarchy. **/
    public CompositeNode getRootNode();
    /** Return the composite node pointed to by the node name **/
    public CompositeNode getCompositeNode(String childNodeName);
    /** Return the leaf node pointed to by the node name. childNodeType allows us to return different node types with the same interface **/
    public LeafNode getLeafNode(String childNodeName, String childNodeType);
    /** Returns true if the leafNodeExists **/
    public boolean leafNodeExists(String childNodeName);
    /** Returns true if the compositeNodeExists **/
    public boolean compositeNodeExists(String childNodeName);
        
    public void addCompositeNode(String childNodeName, CompositeNode addNode);
    public void addLeafNode(String childNodeName, LeafNode addNode);
    
    public String getCompositeNodeKey(String nodeName);
    public String getLeafNodeKey(String nodeName);
    
}

