package com.jamonapi;

/** Class used to test all classes in JAMon.  It is only used during testing.  Mostly it calls other classes Main method.  JAMon
 *  places test code in main() methods.  TestClass also adds test code of its own
 **/

public class TestClass extends java.lang.Object implements Runnable {
    
    static final int THREADS=250;
    
    private int threadNum;
    
    public TestClass(int threadNum, long lobits, long hibits, AccumulateMonitor mon) {
        this.threadNum=threadNum;
        this.lobits=lobits;
        this.hibits=hibits;
        this.mon=mon;
    }
    
    protected TestClass(){}
    
    private static void log(Object obj)  {
        System.out.println("It took "+obj);
    }
    
    public void run() {
        // Alternating threads are either setting the high or lo bit.  The idea is that if a thread
        // is interrupted before mon.increase(...) we may get a different value in mon than expected.
        // The expected value is compared to the actual value in main(...).
        try {
            long incr=0;
            if (threadNum%2==0) {
                incr=lobits;
                Thread.sleep(10);
            }
            else 
                incr=hibits;
            
            mon.increase(incr);
        }
        catch(Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        
    }
    
    long lobits, hibits;
    
    AccumulateMonitor mon;
    
    static private class TimingMonitorThreads implements Runnable {
        Monitor mon;
        TimingMonitorThreads(Monitor mon) {
            this.mon=mon;
        }
        public void run() {
            mon.start().stop();
        }
    }
    
    
    public static void main(String[] args) throws Exception {
       
        System.out.println("***** Class unit tests");
        
        System.out.println("\nAccumulateMonitor.main() test code - all numbers should be equal");
        AccumulateMonitor.main(null);
        
        System.out.println("\nTimeStatsMonitor.main()");
        TimeStatsMonitor.main(null);
        
        System.out.println("\nTimeStatsDistMonitor.main()");
        TimeStatsDistMonitor.main(null);
        
        System.out.println("\nActiveStatsMonitor.main()");
        ActiveStatsMonitor.main(null);
        
        System.out.println("\nTimingMonitor.main() test code - all numbers should be equal");
        TimingMonitor.main(null);
        
        System.out.println("\nLastAccessMonitor.main()");
        LastAccessMonitor.main(null);
        
        System.out.println("\nMonitorFactory.main()");
        MonitorFactory.main(null);
        
        TestClass test=new TestClass();
        
        Monitor timingMon;
        
        System.out.println("\n***** MonitorFactory.getData():");
        
        Monitor m1=MonitorFactory.start("pages.purchase.test");
        Monitor m2=MonitorFactory.start("steve.souza.test");
        
        Thread.sleep(350);
        m1.stop();
        Thread.sleep(650);
        m2.stop();
        
        
        String [][] rows=MonitorFactory.getRootMonitor().getData();
        
        for (int i=0; i<rows.length; i++) {
            String rowData="row"+i+"=[";
            for (int j=0; j<rows[0].length; j++)
            {rowData+=rows[i][j]+", ";}
            
            System.out.println(rowData+"]");
        }
        
        System.out.println("\ncomposite tostring()="+MonitorFactory.getRootMonitor());
        System.out.println("pages composite tostring()="+MonitorFactory.getComposite("pages"));
        
        System.out.println("\n***** Multi-threaded test");
        
        long LOBIT=0x00000001;//1
        long HIBIT=0x10000000;//268,435,456
        
        timingMon=MonitorFactory.start();
        ThreadGroup threadGroup=new ThreadGroup("threadGroup");
        
        //Note mon1 is shared by all instances of the thread and so will test concurrent access.
        AccumulateMonitor mon1=new AccumulateMonitor();
        for (int i=0; i<THREADS; i++) // mon1 should be THREADS*1
            new Thread(threadGroup, new TestClass(i, LOBIT, LOBIT, mon1)).start();
        
        AccumulateMonitor mon2=new AccumulateMonitor();
        for (int i=0; i<THREADS; i++)//THREADS*HIBIT
            new Thread(threadGroup, new TestClass(i, HIBIT, HIBIT, mon2)).start();
        
        AccumulateMonitor mon3=new AccumulateMonitor();
        for (int i=0; i<THREADS; i++)  //(THREADS/2)*LOBIT + (THREADS/2)*HIBIT  
            new Thread(threadGroup, new TestClass(i, LOBIT, HIBIT, mon3)).start();
        
        while(threadGroup.activeCount()!=0)
            ;
        
        System.out.println("Threads have finished processing. It took "+timingMon.stop());
        System.out.println(THREADS+"="+mon1);
        System.out.println(THREADS*HIBIT+"="+mon2);
        System.out.println((THREADS/2)*LOBIT + (THREADS/2)*HIBIT +"="+mon3);
        
        Monitor mon4=MonitorFactory.start("TimingMonitorThreadTest").stop();
        threadGroup=new ThreadGroup("timingMonitorThreads");
        for (int i=0; i<THREADS; i++)
            new Thread(threadGroup, new TimingMonitorThreads(mon4)).start();
        
        while(threadGroup.activeCount()!=0)
            ;
        
        System.out.println("hits should be "+(THREADS+1)+"= "+mon4.stop());

        System.out.println("\n***** MonitorComposite.getHeader():");
        String[] header=MonitorComposite.getHeader();
        
        for(int i=0; i<header.length; i++)
            System.out.println(header[i]);
        
        System.out.println("\n***** MonitorFactory.getReport() 1:");
        System.out.println(MonitorFactory.getReport());
        
        System.out.println("\n***** MonitorFactory.getReport() 2 (after setting admin page to 'JAMon/JAMonAdmin.jsp':");
        MonitorFactory.setJAMonAdminPage("JAMon/JAMonAdmin.jsp");
        System.out.println(MonitorFactory.getReport());

        TestClassPerformance.main(args);
        
    }
}


