package com.jamonapi;

/** Null implementation of the Monitor interface.  Null objects are discussed in Martin Fowler's refactoring book.
 *  This class is used when the MonitorFactory is disabled.  So when the MonitorFactory is disabled resource usage 
 *  is very low and performance is very fast.
 *  
 * All methods have empty/do nothing implementations.
**/


final public class NullMonitor extends BaseMonitor {
    protected NullMonitor() {
        // Do nothing
    }
    
    public boolean isPrimary() {
        return false;
    }
    
    public void setPrimary(boolean primary) {
    }
}

