package com.jamonapi;

import java.util.*;

/** Null implementation of the AccumulateMonitorInterface.  Null objects are discussed in Martin Fowler's refactoring book.
 *  The NullAccumulateMonitor is a singleton (Gang of 4 pattern) and is used when the MonitorFactory is disabled.  So when 
 *  the MonitorFactory is disabled resource usage is very low and performance is very fast.
 *  
 * All methods have empty/do nothing implementations.
**/


public class NullAccumulateMonitor implements AccumulateMonitorInterface {
    NullAccumulateMonitor() {}
    
    private static NullAccumulateMonitor nullMon=new NullAccumulateMonitor();
    
    public static AccumulateMonitorInterface createInstance() {
        return nullMon;
    }
    
    public void start() {
    }
    
    public void stop() {
    }
        
    public long getAccrued() {
        return 0;
    }
    
    public void increase(long increaseValue) {
    }
    
    public void increase() {
    }
    
    
    public void reset() {
    }
    
    public void getData(ArrayList rowData) {
    }
    
    public void getHeader(ArrayList header) {
    }
    
    public String toString() {
        return "";
    }
    
    
    public boolean isPrimary() {
        return false;
    }
    
    public void setPrimary(boolean primary) {
    }
}

