package com.jamonapi;

import com.jamonapi.utils.*;
import java.util.*;

/** The MonitorLeafFactory is an important class in that it determines how to create Monitor objects.  It uses the Gang of 4's
 * decorator pattern to create the Monitors
 **/


public class MonitorLeafFactory extends java.lang.Object implements MonitorLeafFactoryInterface {
    public static final String DEFAULT="def";
    public static final String PRIMARY="primary";
    
    /** Get the header used in the monitor html report.  Each Monitor in the decorator chain will provide its own header value **/
    public String[] getHeader(){
        ArrayList header=new ArrayList();// the arraylist will be created by the called routine.
        TimingMonitor mon=(TimingMonitor) createInstance(DEFAULT);
        header.add("Monitor Label");
        mon.getHeader(header);  // appends monitor data to the arraylist
        
        String[] headerArray=new String[0];
        return (String[]) header.toArray(headerArray);
        
    }
    

    /** This is the method that creates monitors.  Note the decorator chaing.  If the Monitor is of type 'Primary' then the monitor
     *  is marked as such.  To change the type of Monitors that are returned simply change this routine.  For example if one of the
     *  new statements is removed in this code then that Monitor will no longer be created.  
     */
    public LeafNode createInstance(String monitorType)     {
        TimingMonitor mon=new TimingMonitor(
        new TimeStatsMonitor(
        new ActiveStatsMonitor(
        new LastAccessMonitor(
        new TimeStatsDistMonitor()))));
        
        if (PRIMARY.equalsIgnoreCase(monitorType))
            mon.setPrimary(true);
        
        return mon;
        
    }
}

