package com.jamonapi;

/**
 * The basic Monitor interface used by all of the Timing related Monitors.  Note I did not use an interface because
 * start() has package access.  Due to multithreading issues I didn't want developers to be able to execute the Monitor's
 * start() method however it did want to ensure that the method was provided.
 */

public abstract class Monitor implements MinimalMonitor {
    /** Start the monitor.  **/
    abstract Monitor start();
    /** Stop the montior **/
    abstract public Monitor stop();
    /** Is this a primary Monitor.  See www.jamonapi.com for an explanation of primary monitors **/
    abstract public boolean isPrimary();
    /** Indicate that this a primary Monitor.  See www.jamonapi.com for an explanation of primary monitors **/
    abstract public void setPrimary(boolean primary);
}

