package com.jamonapi;

import java.util.*;

/**
 * Most basic interfaces that all monitors must implement.  Right now the only type of Monitors are timing related monitors, but
 * the interface is generic that future types may be added.  For example it would be easy to add a Monitor that could track the number of
 * bytes sent to a client browser or something similar.
 *
 **/
public interface MinimalMonitor {
    /** Return the accrued value.  In the case of timing monitors this would be the elapsed time since the timer started **/
    public long getAccrued();
    /** Increase the monitors value **/
    public void increase(long increaseValue);
    /** Erase the values in the monitor **/
    public void reset();
    /** Add this elements value to the ArrayList.  This is used to display the Monitor in a tabular format. **/
    public void getData(ArrayList rowData);
    /** Add this elements header value to an ArrayList.  This is used to display the Monitor in a tabular format. **/
    public void getHeader(ArrayList header);
}

