package com.jamonapi;

import java.util.*;
import java.text.*;
/** Class that tracks when a Monitor was first and last called.    **/

public class LastAccessMonitor extends AccumulateMonitor {
    static private final String FIRSTACCESS="First access";
    static private final String LASTACCESS="Last access";
    private boolean isFirstAccess=true;
    private long firstAccessTime;
    
    public LastAccessMonitor()     {
        super();
    }
    
    public LastAccessMonitor(AccumulateMonitorInterface childMonitor)     {
        super(childMonitor);
    }
    
    
    /** Updates the accrued value which indicates when this method was last invoked.  This is used to track when the 
      * monitor was last called 
     **/
    synchronized protected void increaseThis(long increaseValue)     {
        accrued=System.currentTimeMillis();
    }
    
    
    /** Erase/wipe out first accessed and last accessed variables **/
    synchronized protected void resetThis(long increaseValue)     {
        firstAccessTime = System.currentTimeMillis();
        accrued         = System.currentTimeMillis();
    }
    
    /** If this is the first time the method is called update the first accessed variable with the current time.  
     **/
    protected void startThis()     {
        if (isFirstAccess) {
            isFirstAccess=false;
            firstAccessTime = System.currentTimeMillis();
        }
        
    }
    
    private String getDateString(long time)     {
        if (time==0)
            return "";
        else
            return DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.DEFAULT).format(new Date(time));
    }
    
    
    synchronized protected String toStringThis()     {
        return  getDisplayString(FIRSTACCESS, getDateString(firstAccessTime), NONE) +
        getDisplayString(LASTACCESS,  getDateString(accrued), NONE);
        
    }
    
    
    synchronized protected void getDataThis(ArrayList rowData)     {
        rowData.add(getDateString(firstAccessTime));
        rowData.add(getDateString(accrued));
    }
    
    protected void getHeaderThis(ArrayList header)     {
        header.add(FIRSTACCESS);
        header.add(LASTACCESS);
    }
    
    
    
    /** Test code for this class **/
    public static void main(String[] args) throws Exception    {
        AccumulateMonitor m=new LastAccessMonitor();
        
        m.start();
        
        System.out.println("current time="+m);
        Thread.sleep(2000);
        m.increase(1);
        System.out.println("above time plus about 2 seconds="+m);
        
    }
}

