package com.jamonapi;


import java.util.*;
import java.text.*;

/** Abstract base class for other Monitors **/

public abstract class BaseMonitor extends Monitor {
    
    
    public long getAccrued() {
        return 0;
    }
    
    
    public String toString() {
        return "";
    }
    
    public  String getAccruedString() {
        return convertToString(getAccrued());
    }
    
    
    protected String convertToString(long value) {
        DecimalFormat numberFormat = (DecimalFormat) NumberFormat.getNumberInstance();
        numberFormat.applyPattern("#,###");
        return numberFormat.format(value);
        
    }
    
    
    
    public void reset(){
        
    }
    
    
    public void increase(long increaseValue){
    }
    
    public Monitor start() {
        return this;
    }
    
    public Monitor stop() {
        return this;
    }
    
    
    public void getData(ArrayList rowData) {
        
    }
    
    
    public void getHeader(ArrayList header) {
    }
}

