/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.widget.TextView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Functions;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.TextViewAfterTextChangeEvent;
import com.jakewharton.rxbinding2.widget.TextViewAfterTextChangeEventObservable;
import com.jakewharton.rxbinding2.widget.TextViewBeforeTextChangeEvent;
import com.jakewharton.rxbinding2.widget.TextViewBeforeTextChangeEventObservable;
import com.jakewharton.rxbinding2.widget.TextViewEditorActionEvent;
import com.jakewharton.rxbinding2.widget.TextViewEditorActionEventObservable;
import com.jakewharton.rxbinding2.widget.TextViewEditorActionObservable;
import com.jakewharton.rxbinding2.widget.TextViewTextChangeEvent;
import com.jakewharton.rxbinding2.widget.TextViewTextChangeEventObservable;
import com.jakewharton.rxbinding2.widget.TextViewTextObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;

public final class RxTextView {
    @CheckResult
    @NonNull
    public static Observable<Integer> editorActions(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return RxTextView.editorActions(view, Functions.PREDICATE_ALWAYS_TRUE);
    }

    @CheckResult
    @NonNull
    public static Observable<Integer> editorActions(@NonNull TextView view, @NonNull Predicate<? super Integer> handled) {
        Preconditions.checkNotNull(view, "view == null");
        Preconditions.checkNotNull(handled, "handled == null");
        return new TextViewEditorActionObservable(view, handled);
    }

    @CheckResult
    @NonNull
    public static Observable<TextViewEditorActionEvent> editorActionEvents(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return RxTextView.editorActionEvents(view, Functions.PREDICATE_ALWAYS_TRUE);
    }

    @CheckResult
    @NonNull
    public static Observable<TextViewEditorActionEvent> editorActionEvents(@NonNull TextView view, @NonNull Predicate<? super TextViewEditorActionEvent> handled) {
        Preconditions.checkNotNull(view, "view == null");
        Preconditions.checkNotNull(handled, "handled == null");
        return new TextViewEditorActionEventObservable(view, handled);
    }

    @CheckResult
    @NonNull
    public static InitialValueObservable<CharSequence> textChanges(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new TextViewTextObservable(view);
    }

    @CheckResult
    @NonNull
    public static InitialValueObservable<TextViewTextChangeEvent> textChangeEvents(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new TextViewTextChangeEventObservable(view);
    }

    @CheckResult
    @NonNull
    public static InitialValueObservable<TextViewBeforeTextChangeEvent> beforeTextChangeEvents(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new TextViewBeforeTextChangeEventObservable(view);
    }

    @CheckResult
    @NonNull
    public static InitialValueObservable<TextViewAfterTextChangeEvent> afterTextChangeEvents(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new TextViewAfterTextChangeEventObservable(view);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> text(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setText(arg_0);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> textRes(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setText(arg_0);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> error(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setError(arg_0);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> errorRes(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return textRes -> view.setError(view.getContext().getResources().getText(textRes.intValue()));
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> hint(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setHint(arg_0);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> hintRes(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setHint(arg_0);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> color(@NonNull TextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return arg_0 -> ((TextView)view).setTextColor(arg_0);
    }

    private RxTextView() {
        throw new AssertionError((Object)"No instances.");
    }
}

