/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.support.annotation.RequiresApi;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.ViewScrollChangeEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

@RequiresApi(value=23)
final class ViewScrollChangeEventObservable
extends Observable<ViewScrollChangeEvent> {
    private final View view;

    ViewScrollChangeEventObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super ViewScrollChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnScrollChangeListener((View.OnScrollChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnScrollChangeListener {
        private final View view;
        private final Observer<? super ViewScrollChangeEvent> observer;

        Listener(View view, Observer<? super ViewScrollChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewScrollChangeEvent.create(v, scrollX, scrollY, oldScrollX, oldScrollY));
            }
        }

        protected void onDispose() {
            this.view.setOnScrollChangeListener(null);
        }
    }
}

