/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.RequiresApi;
import android.view.MenuItem;
import android.widget.Toolbar;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

@RequiresApi(value=21)
final class ToolbarItemClickObservable
extends Observable<MenuItem> {
    private final Toolbar view;

    ToolbarItemClickObservable(Toolbar view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super MenuItem> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements Toolbar.OnMenuItemClickListener {
        private final Toolbar view;
        private final Observer<? super MenuItem> observer;

        Listener(Toolbar view, Observer<? super MenuItem> observer) {
            this.view = view;
            this.observer = observer;
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)item);
                return true;
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnMenuItemClickListener(null);
        }
    }
}

