/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.widget.TextViewTextChangeEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class TextViewTextChangeEventObservable
extends InitialValueObservable<TextViewTextChangeEvent> {
    private final TextView view;

    TextViewTextChangeEventObservable(TextView view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super TextViewTextChangeEvent> observer) {
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addTextChangedListener((TextWatcher)listener);
    }

    @Override
    protected TextViewTextChangeEvent getInitialValue() {
        return TextViewTextChangeEvent.create(this.view, this.view.getText(), 0, 0, 0);
    }

    static final class Listener
    extends MainThreadDisposable
    implements TextWatcher {
        private final TextView view;
        private final Observer<? super TextViewTextChangeEvent> observer;

        Listener(TextView view, Observer<? super TextViewTextChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)TextViewTextChangeEvent.create(this.view, s, start, before, count));
            }
        }

        public void afterTextChanged(Editable editable) {
        }

        protected void onDispose() {
            this.view.removeTextChangedListener((TextWatcher)this);
        }
    }
}

