/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.Nullable;
import android.widget.SeekBar;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SeekBarChangeObservable
extends InitialValueObservable<Integer> {
    private final SeekBar view;
    @Nullable
    private final Boolean shouldBeFromUser;

    SeekBarChangeObservable(SeekBar view, @Nullable Boolean shouldBeFromUser) {
        this.view = view;
        this.shouldBeFromUser = shouldBeFromUser;
    }

    @Override
    protected void subscribeListener(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.shouldBeFromUser, observer);
        this.view.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected Integer getInitialValue() {
        return this.view.getProgress();
    }

    static final class Listener
    extends MainThreadDisposable
    implements SeekBar.OnSeekBarChangeListener {
        private final SeekBar view;
        private final Boolean shouldBeFromUser;
        private final Observer<? super Integer> observer;

        Listener(SeekBar view, Boolean shouldBeFromUser, Observer<? super Integer> observer) {
            this.view = view;
            this.shouldBeFromUser = shouldBeFromUser;
            this.observer = observer;
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (!(this.isDisposed() || this.shouldBeFromUser != null && this.shouldBeFromUser != fromUser)) {
                this.observer.onNext((Object)progress);
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
        }

        protected void onDispose() {
            this.view.setOnSeekBarChangeListener(null);
        }
    }
}

