/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.AdapterViewItemClickEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AutoCompleteTextViewItemClickEventObservable
extends Observable<AdapterViewItemClickEvent> {
    private final AutoCompleteTextView view;

    AutoCompleteTextViewItemClickEventObservable(AutoCompleteTextView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super AdapterViewItemClickEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemClickListener {
        private final AutoCompleteTextView view;
        private final Observer<? super AdapterViewItemClickEvent> observer;

        Listener(AutoCompleteTextView view, Observer<? super AdapterViewItemClickEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)AdapterViewItemClickEvent.create(parent, view, position, id));
            }
        }

        protected void onDispose() {
            this.view.setOnItemClickListener(null);
        }
    }
}

