/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.widget.TextViewBeforeTextChangeEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class TextViewBeforeTextChangeEventObservable
extends InitialValueObservable<TextViewBeforeTextChangeEvent> {
    private final TextView view;

    TextViewBeforeTextChangeEventObservable(TextView view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super TextViewBeforeTextChangeEvent> observer) {
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addTextChangedListener((TextWatcher)listener);
    }

    @Override
    protected TextViewBeforeTextChangeEvent getInitialValue() {
        return TextViewBeforeTextChangeEvent.create(this.view, this.view.getText(), 0, 0, 0);
    }

    static final class Listener
    extends MainThreadDisposable
    implements TextWatcher {
        private final TextView view;
        private final Observer<? super TextViewBeforeTextChangeEvent> observer;

        Listener(TextView view, Observer<? super TextViewBeforeTextChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)TextViewBeforeTextChangeEvent.create(this.view, s, start, count, after));
            }
        }

        public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
        }

        protected void onDispose() {
            this.view.removeTextChangedListener((TextWatcher)this);
        }
    }
}

