/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.RatingBar;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RatingBarRatingChangeObservable
extends InitialValueObservable<Float> {
    private final RatingBar view;

    RatingBarRatingChangeObservable(RatingBar view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super Float> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnRatingBarChangeListener((RatingBar.OnRatingBarChangeListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected Float getInitialValue() {
        return Float.valueOf(this.view.getRating());
    }

    static final class Listener
    extends MainThreadDisposable
    implements RatingBar.OnRatingBarChangeListener {
        private final RatingBar view;
        private final Observer<? super Float> observer;

        Listener(RatingBar view, Observer<? super Float> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onRatingChanged(RatingBar ratingBar, float rating, boolean fromUser) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Float.valueOf(rating));
            }
        }

        protected void onDispose() {
            this.view.setOnRatingBarChangeListener(null);
        }
    }
}

