/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.v4.widget.SwipeRefreshLayout;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SwipeRefreshLayoutRefreshObservable
extends Observable<Object> {
    private final SwipeRefreshLayout view;

    SwipeRefreshLayoutRefreshObservable(SwipeRefreshLayout view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements SwipeRefreshLayout.OnRefreshListener {
        private final SwipeRefreshLayout view;
        private final Observer<? super Object> observer;

        Listener(SwipeRefreshLayout view, Observer<? super Object> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onRefresh() {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.view.setOnRefreshListener(null);
        }
    }
}

