/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.v4.widget.NestedScrollView;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.ViewScrollChangeEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class NestedScrollViewScrollChangeEventObservable
extends Observable<ViewScrollChangeEvent> {
    private final NestedScrollView view;

    NestedScrollViewScrollChangeEventObservable(NestedScrollView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super ViewScrollChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements NestedScrollView.OnScrollChangeListener {
        private final NestedScrollView view;
        private final Observer<? super ViewScrollChangeEvent> observer;

        Listener(NestedScrollView view, Observer<? super ViewScrollChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewScrollChangeEvent.create((View)this.view, (int)scrollX, (int)scrollY, (int)oldScrollX, (int)oldScrollY));
            }
        }

        protected void onDispose() {
            this.view.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)null);
        }
    }
}

