/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.SearchView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SearchViewQueryTextChangesObservable
extends InitialValueObservable<CharSequence> {
    private final SearchView view;

    SearchViewQueryTextChangesObservable(SearchView view) {
        this.view = view;
    }

    protected void subscribeListener(Observer<? super CharSequence> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnQueryTextListener((SearchView.OnQueryTextListener)listener);
    }

    protected CharSequence getInitialValue() {
        return this.view.getQuery();
    }

    final class Listener
    extends MainThreadDisposable
    implements SearchView.OnQueryTextListener {
        private final SearchView searchView;
        private final Observer<? super CharSequence> observer;

        Listener(SearchView searchView, Observer<? super CharSequence> observer) {
            this.searchView = searchView;
            this.observer = observer;
        }

        public boolean onQueryTextChange(String s) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)s);
                return true;
            }
            return false;
        }

        public boolean onQueryTextSubmit(String query) {
            return false;
        }

        protected void onDispose() {
            this.searchView.setOnQueryTextListener(null);
        }
    }
}

