/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.Toolbar;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ToolbarNavigationClickObservable
extends Observable<Object> {
    private final Toolbar view;

    ToolbarNavigationClickObservable(Toolbar view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setNavigationOnClickListener((View.OnClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnClickListener {
        private final Toolbar toolbar;
        private final Observer<? super Object> observer;

        Listener(Toolbar toolbar, Observer<? super Object> observer) {
            this.toolbar = toolbar;
            this.observer = observer;
        }

        public void onClick(View view) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.toolbar.setNavigationOnClickListener(null);
        }
    }
}

