/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.processphoenix;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProcessPhoenix
extends Activity {
    private static final String KEY_RESTART_INTENTS = "phoenix_restart_intents";
    private static final String KEY_MAIN_PROCESS_PID = "phoenix_main_process_pid";

    public static void triggerRebirth(Context context) {
        ProcessPhoenix.triggerRebirth(context, ProcessPhoenix.getRestartIntent(context));
    }

    public static void triggerRebirth(Context context, Intent ... nextIntents) {
        if (nextIntents.length < 1) {
            throw new IllegalArgumentException("intents cannot be empty");
        }
        nextIntents[0].addFlags(0x10008000);
        Intent intent = new Intent(context, ProcessPhoenix.class);
        intent.addFlags(0x10000000);
        intent.putParcelableArrayListExtra(KEY_RESTART_INTENTS, new ArrayList<Intent>(Arrays.asList(nextIntents)));
        intent.putExtra(KEY_MAIN_PROCESS_PID, Process.myPid());
        context.startActivity(intent);
    }

    private static Intent getRestartIntent(Context context) {
        String packageName = context.getPackageName();
        Intent defaultIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (defaultIntent != null) {
            return defaultIntent;
        }
        throw new IllegalStateException("Unable to determine default activity for " + packageName + ". Does an activity specify the DEFAULT category in its intent filter?");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Process.killProcess((int)this.getIntent().getIntExtra(KEY_MAIN_PROCESS_PID, -1));
        ArrayList intents = this.getIntent().getParcelableArrayListExtra(KEY_RESTART_INTENTS);
        this.startActivities(intents.toArray(new Intent[intents.size()]));
        this.finish();
        Runtime.getRuntime().exit(0);
    }

    public static boolean isPhoenixProcess(Context context) {
        int currentPid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = manager.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.pid != currentPid || !processInfo.processName.endsWith(":phoenix")) continue;
                return true;
            }
        }
        return false;
    }
}

