/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.j256.ormlite.android.AndroidDatabaseConnection;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseConnectionProxyFactory;

public class AndroidConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static final Logger logger = LoggerFactory.getLogger(AndroidConnectionSource.class);
    private final SQLiteOpenHelper helper;
    private final SQLiteDatabase sqliteDatabase;
    private DatabaseConnection connection = null;
    private volatile boolean isOpen = true;
    private final DatabaseType databaseType = new SqliteAndroidDatabaseType();
    private static DatabaseConnectionProxyFactory connectionProxyFactory;
    private boolean cancelQueriesEnabled = false;

    public AndroidConnectionSource(SQLiteOpenHelper helper) {
        this.helper = helper;
        this.sqliteDatabase = null;
    }

    public AndroidConnectionSource(SQLiteDatabase sqliteDatabase) {
        this.helper = null;
        this.sqliteDatabase = sqliteDatabase;
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws java.sql.SQLException {
        return this.getReadWriteConnection(tableName);
    }

    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws java.sql.SQLException {
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        if (this.connection == null) {
            SQLiteDatabase db;
            if (this.sqliteDatabase == null) {
                try {
                    db = this.helper.getWritableDatabase();
                }
                catch (SQLException e) {
                    throw new java.sql.SQLException("Getting a writable database from helper " + this.helper + " failed", e);
                }
            } else {
                db = this.sqliteDatabase;
            }
            this.connection = new AndroidDatabaseConnection(db, true, this.cancelQueriesEnabled);
            if (connectionProxyFactory != null) {
                this.connection = connectionProxyFactory.createProxy(this.connection);
            }
            logger.trace("created connection {} for db {}, helper {}", this.connection, (Object)db, (Object)this.helper);
        } else {
            logger.trace("{}: returning read-write connection {}, helper {}", this, (Object)this.connection, (Object)this.helper);
        }
        return this.connection;
    }

    @Override
    public void releaseConnection(DatabaseConnection connection) {
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws java.sql.SQLException {
        return this.saveSpecial(connection);
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public void closeQuietly() {
        this.close();
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public boolean isOpen(String tableName) {
        return this.isOpen;
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return true;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        AndroidConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }

    public boolean isCancelQueriesEnabled() {
        return this.cancelQueriesEnabled;
    }

    public void setCancelQueriesEnabled(boolean cancelQueriesEnabled) {
        this.cancelQueriesEnabled = cancelQueriesEnabled;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }
}

