/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.android.compat.ApiCompatibility;
import com.j256.ormlite.android.compat.ApiCompatibilityUtils;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.util.ArrayList;
import java.util.List;

public class AndroidCompiledStatement
implements CompiledStatement {
    private static Logger logger = LoggerFactory.getLogger(AndroidCompiledStatement.class);
    private static final String[] NO_STRING_ARGS = new String[0];
    private static final ApiCompatibility apiCompatibility = ApiCompatibilityUtils.getCompatibility();
    private final String sql;
    private final SQLiteDatabase db;
    private final StatementBuilder.StatementType type;
    private final boolean cancelQueriesEnabled;
    private final boolean cacheStore;
    private Cursor cursor;
    private List<Object> args;
    private Integer max;
    private ApiCompatibility.CancellationHook cancellationHook;

    public AndroidCompiledStatement(String sql, SQLiteDatabase db, StatementBuilder.StatementType type, boolean cancelQueriesEnabled, boolean cacheStore) {
        this.sql = sql;
        this.db = db;
        this.type = type;
        this.cancelQueriesEnabled = cancelQueriesEnabled;
        this.cacheStore = cacheStore;
    }

    @Override
    public int getColumnCount() throws java.sql.SQLException {
        return this.getCursor().getColumnCount();
    }

    @Override
    public String getColumnName(int column) throws java.sql.SQLException {
        return this.getCursor().getColumnName(column);
    }

    @Override
    public DatabaseResults runQuery(ObjectCache objectCache) throws java.sql.SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + (Object)((Object)this.type) + " statement");
        }
        return new AndroidDatabaseResults(this.getCursor(), objectCache, this.cacheStore);
    }

    @Override
    public int runUpdate() throws java.sql.SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + (Object)((Object)this.type) + " statement");
        }
        String finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
        return AndroidCompiledStatement.execSql(this.db, "runUpdate", finalSql, this.getArgArray());
    }

    @Override
    public int runExecute() throws java.sql.SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + (Object)((Object)this.type) + " statement");
        }
        return AndroidCompiledStatement.execSql(this.db, "runExecute", this.sql, this.getArgArray());
    }

    @Override
    public void close() throws Exception {
        if (this.cursor != null && !this.cursor.isClosed()) {
            try {
                this.cursor.close();
            }
            catch (SQLException e) {
                throw new java.sql.SQLException("Problems closing Android cursor", e);
            }
        }
        this.cancellationHook = null;
    }

    @Override
    public void closeQuietly() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public void cancel() {
        if (this.cancellationHook != null) {
            this.cancellationHook.cancel();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws java.sql.SQLException {
        this.isInPrep();
        if (this.args == null) {
            this.args = new ArrayList<Object>();
        }
        if (obj == null) {
            this.args.add(parameterIndex, null);
            return;
        }
        switch (sqlType) {
            case STRING: 
            case LONG_STRING: 
            case DATE: 
            case BOOLEAN: 
            case CHAR: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                this.args.add(parameterIndex, obj.toString());
                break;
            }
            case BYTE_ARRAY: 
            case SERIALIZABLE: {
                this.args.add(parameterIndex, obj);
                break;
            }
            case BLOB: 
            case BIG_DECIMAL: {
                throw new java.sql.SQLException("Invalid Android type: " + (Object)((Object)sqlType));
            }
            default: {
                throw new java.sql.SQLException("Unknown sql argument type: " + (Object)((Object)sqlType));
            }
        }
    }

    @Override
    public void setMaxRows(int max) throws java.sql.SQLException {
        this.isInPrep();
        this.max = max;
    }

    @Override
    public void setQueryTimeout(long millis) {
    }

    @Override
    public String getStatement() {
        return this.sql;
    }

    public Cursor getCursor() throws java.sql.SQLException {
        if (this.cursor == null) {
            String finalSql = null;
            try {
                finalSql = this.max == null ? this.sql : this.sql + " LIMIT " + this.max;
                if (this.cancelQueriesEnabled) {
                    this.cancellationHook = apiCompatibility.createCancellationHook();
                }
                this.cursor = apiCompatibility.rawQuery(this.db, finalSql, this.getStringArray(), this.cancellationHook);
                this.cursor.moveToFirst();
                logger.trace("{}: started rawQuery cursor for: {}", this, (Object)finalSql);
            }
            catch (SQLException e) {
                throw new java.sql.SQLException("Problems executing Android query: " + finalSql, e);
            }
        }
        return this.cursor;
    }

    public String toString() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int execSql(SQLiteDatabase db, String label, String finalSql, Object[] argArray) throws java.sql.SQLException {
        int result;
        try {
            db.execSQL(finalSql, argArray);
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("Problems executing " + label + " Android statement: " + finalSql, e);
        }
        try (SQLiteStatement stmt = null;){
            stmt = db.compileStatement("SELECT CHANGES()");
            result = (int)stmt.simpleQueryForLong();
        }
        logger.trace("executing statement {} changed {} rows: {}", (Object)label, (Object)result, (Object)finalSql);
        return result;
    }

    private void isInPrep() throws java.sql.SQLException {
        if (this.cursor != null) {
            throw new java.sql.SQLException("Query already run. Cannot add argument values.");
        }
    }

    private Object[] getArgArray() {
        if (this.args == null) {
            return NO_STRING_ARGS;
        }
        return this.args.toArray(new Object[this.args.size()]);
    }

    private String[] getStringArray() {
        if (this.args == null) {
            return NO_STRING_ARGS;
        }
        return this.args.toArray(new String[this.args.size()]);
    }
}

