/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.j256.ormlite.android.AndroidDatabaseConnection;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;

public class AndroidConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static final Logger logger = LoggerFactory.getLogger(AndroidConnectionSource.class);
    private final SQLiteOpenHelper helper;
    private final SQLiteDatabase sqliteDatabase;
    private AndroidDatabaseConnection connection = null;
    private volatile boolean isOpen = true;
    private final DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public AndroidConnectionSource(SQLiteOpenHelper helper) {
        this.helper = helper;
        this.sqliteDatabase = null;
    }

    public AndroidConnectionSource(SQLiteDatabase sqliteDatabase) {
        this.helper = null;
        this.sqliteDatabase = sqliteDatabase;
    }

    public DatabaseConnection getReadOnlyConnection() throws java.sql.SQLException {
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadWriteConnection() throws java.sql.SQLException {
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        if (this.connection == null) {
            if (this.sqliteDatabase == null) {
                SQLiteDatabase db;
                try {
                    db = this.helper.getWritableDatabase();
                }
                catch (SQLException e) {
                    throw SqlExceptionUtil.create((String)"Getting a writable database from SQLiteOpenHelper failed", (Throwable)e);
                }
                this.connection = new AndroidDatabaseConnection(db, true);
            } else {
                this.connection = new AndroidDatabaseConnection(this.sqliteDatabase, true);
            }
        }
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) {
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws java.sql.SQLException {
        return this.saveSpecial(connection);
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    public void close() {
        this.isOpen = false;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean isOpen() {
        return this.isOpen;
    }
}

