/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.j256.ormlite.android.AndroidCompiledStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.SQLException;
import java.sql.Savepoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidDatabaseConnection
implements DatabaseConnection {
    private final SQLiteDatabase db;
    private final boolean readWrite;

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite) {
        this.db = db;
        this.readWrite = readWrite;
    }

    @Override
    public boolean isAutoCommitSupported() throws SQLException {
        return false;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return !this.db.inTransaction();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public Savepoint setSavePoint(String name) throws SQLException {
        this.db.beginTransaction();
        return null;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    @Override
    public void commit(Savepoint savepoint) throws SQLException {
        this.db.setTransactionSuccessful();
        this.db.endTransaction();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.db.endTransaction();
    }

    @Override
    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type) throws SQLException {
        AndroidCompiledStatement stmt = new AndroidCompiledStatement(statement, this.db, type);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        SQLiteStatement stmt = this.db.compileStatement(statement);
        try {
            this.bindArgs(stmt, args, argFieldTypes);
            stmt.executeInsert();
            int n = 1;
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String statement, Object[] args, SqlType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws SQLException {
        SQLiteStatement stmt = this.db.compileStatement(statement);
        try {
            this.bindArgs(stmt, args, argFieldTypes);
            long rowId = stmt.executeInsert();
            keyHolder.addKey(rowId);
            int n = 1;
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        SQLiteStatement stmt = this.db.compileStatement(statement);
        try {
            this.bindArgs(stmt, args, argFieldTypes);
            stmt.execute();
            int n = 1;
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public int delete(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Object queryForOne(String statement, Object[] args, SqlType[] argFieldTypes, GenericRowMapper<T> rowMapper) throws SQLException {
        Cursor cursor = this.db.rawQuery(statement, this.toStrings(args));
        try {
            AndroidDatabaseResults results = new AndroidDatabaseResults(cursor);
            if (!results.next()) {
                Object var7_7 = null;
                return var7_7;
            }
            T first = rowMapper.mapRow(results);
            if (results.next()) {
                Object object = MORE_THAN_ONE;
                return object;
            }
            T t = first;
            return t;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryForLong(String statement) throws SQLException {
        SQLiteStatement stmt = this.db.compileStatement(statement);
        try {
            long l = stmt.simpleQueryForLong();
            return l;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.db.close();
    }

    private void bindArgs(SQLiteStatement stmt, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        if (args == null) {
            return;
        }
        block7: for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int argIndex = AndroidDatabaseResults.androidColumnIndexToJdbc(i);
            if (arg == null) {
                stmt.bindNull(argIndex);
                continue;
            }
            switch (argFieldTypes[i]) {
                case STRING: {
                    stmt.bindString(argIndex, arg.toString());
                    continue block7;
                }
                case BOOLEAN: {
                    stmt.bindLong(argIndex, (Boolean)arg != false ? 1L : 0L);
                    continue block7;
                }
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    stmt.bindLong(argIndex, ((Number)arg).longValue());
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    stmt.bindDouble(argIndex, ((Number)arg).doubleValue());
                    continue block7;
                }
                case SERIALIZABLE: {
                    stmt.bindBlob(argIndex, (byte[])arg);
                }
            }
        }
    }

    private String[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        String[] strings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : arg.toString();
        }
        return strings;
    }
}

