/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.CommonsLoggingLog;
import com.j256.ormlite.logger.LocalLog;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Log4jLog;
import com.j256.ormlite.logger.Logger;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static LogType logType;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        if (logType == null) {
            logType = LoggerFactory.findLogType();
        }
        return new Logger(logType.createLog(className));
    }

    public static String getSimpleClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length == 0) {
            return className;
        }
        return parts[parts.length - 1];
    }

    private static LogType findLogType() {
        for (LogType logType : LogType.values()) {
            if (!logType.isAvailable()) continue;
            return logType;
        }
        return LogType.LOCAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogType {
        COMMONS_LOGGING("org.apache.commons.logging.LogFactory"){

            public Log createLog(String classLabel) {
                return new CommonsLoggingLog(classLabel);
            }
        }
        ,
        LOG4J("org.apache.log4j.Logger"){

            public Log createLog(String classLabel) {
                return new Log4jLog(classLabel);
            }
        }
        ,
        ANDROID("android.util.Log"){

            public Log createLog(String classLabel) {
                try {
                    Class<?> clazz = Class.forName("com.j256.ormlite.android.AndroidLog");
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    return (Log)constructor.newInstance(classLabel);
                }
                catch (Exception e) {
                    return LOCAL.createLog(classLabel);
                }
            }
        }
        ,
        LOCAL("com.j256.ormlite.logger.LocalLog"){

            public Log createLog(String classLabel) {
                return new LocalLog(classLabel);
            }

            public boolean isAvailable() {
                return true;
            }
        };

        private String detectClassName;

        private LogType(String detectClassName) {
            this.detectClassName = detectClassName;
        }

        public abstract Log createLog(String var1);

        public boolean isAvailable() {
            try {
                Class.forName(this.detectClassName);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

