/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.parser;

import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.parser.State;
import com.itextpdf.tool.xml.css.parser.state.CommentEnd;
import com.itextpdf.tool.xml.css.parser.state.CommentInside;
import com.itextpdf.tool.xml.css.parser.state.CommentStart;
import com.itextpdf.tool.xml.css.parser.state.Properties;
import com.itextpdf.tool.xml.css.parser.state.Rule;
import com.itextpdf.tool.xml.css.parser.state.Unknown;
import java.util.LinkedHashMap;

public class CssStateController {
    private State current;
    private State previous;
    private final State commentEnd;
    private final State commentStart;
    private final State commentInside;
    private final StringBuilder buffer;
    private final State properties;
    private final State unknown;
    private String currentSelector;
    private final State rule;
    private final CssUtils utils;
    private final CssFile css;

    public CssStateController(CssFile file) {
        this.css = file;
        this.utils = CssUtils.getInstance();
        this.buffer = new StringBuilder();
        this.commentStart = new CommentStart(this);
        this.commentEnd = new CommentEnd(this);
        this.commentInside = new CommentInside(this);
        this.unknown = new Unknown(this);
        this.properties = new Properties(this);
        this.rule = new Rule(this);
        this.current = this.unknown;
    }

    public void append(char c) {
        this.buffer.append(c);
    }

    public void previous() {
        this.current = this.previous;
    }

    public void process(char c) {
        this.current.process(c);
    }

    private void processProps(String props) {
        String[] split = props.split(";");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String prop : split) {
            String[] propSplit = prop.split(":");
            if (propSplit.length != 2) continue;
            map.put(this.utils.stripDoubleSpacesTrimAndToLowerCase(propSplit[0]), this.utils.stripDoubleSpacesAndTrim(propSplit[1]));
        }
        if (this.currentSelector.contains(",")) {
            String[] selectors = this.currentSelector.split(",");
            for (int i = 0; i < selectors.length; ++i) {
                selectors[i] = this.utils.stripDoubleSpacesAndTrim(selectors[i]);
                if (selectors[i].length() != 0) continue;
                return;
            }
            for (String selector : selectors) {
                if (this.css.add(selector, map)) continue;
                map.clear();
            }
        } else {
            this.css.add(this.utils.stripDoubleSpacesAndTrim(this.currentSelector), map);
        }
    }

    private void setState(State state) {
        this.current = state;
    }

    private void setPrevious() {
        this.previous = this.current;
    }

    public void stateCommentEnd() {
        this.setState(this.commentEnd);
    }

    public void stateCommentInside() {
        this.setState(this.commentInside);
    }

    public void stateCommentStart() {
        this.setPrevious();
        this.setState(this.commentStart);
    }

    public void stateProperties() {
        this.previous = this.current;
        this.setState(this.properties);
    }

    public void stateUnknown() {
        this.setState(this.unknown);
    }

    public void stateRule() {
        this.setState(this.rule);
    }

    public void storeSelector() {
        this.currentSelector = this.buffer.toString();
        this.buffer.setLength(0);
    }

    public void storeProperties() {
        this.processProps(this.buffer.toString());
        this.buffer.setLength(0);
    }
}

