/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html.table;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.HeightCalculator;
import com.itextpdf.tool.xml.css.WidthCalculator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.table.TableBorderEvent;
import com.itextpdf.tool.xml.html.table.TableRowElement;
import com.itextpdf.tool.xml.html.table.TableStyleValues;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends AbstractTagProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    private static final CssUtils utils = CssUtils.getInstance();
    private static final FontSizeTranslator fst = FontSizeTranslator.getInstance();

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            boolean percentage = false;
            String widthValue = tag.getCSS().get("width");
            if (widthValue == null) {
                widthValue = tag.getAttributes().get("width");
            }
            if (widthValue != null && widthValue.trim().endsWith("%")) {
                percentage = true;
            }
            int numberOfColumns = 0;
            ArrayList<TableRowElement> tableRows = new ArrayList<TableRowElement>(currentContent.size());
            ArrayList<Element> invalidRowElements = new ArrayList<Element>(1);
            String repeatHeader = tag.getCSS().get("repeat-header");
            String repeatFooter = tag.getCSS().get("repeat-footer");
            int headerRows = 0;
            int footerRows = 0;
            for (Element e : currentContent) {
                int localNumCols = 0;
                if (e instanceof TableRowElement) {
                    TableRowElement tableRowElement = (TableRowElement)e;
                    for (HtmlCell cell : tableRowElement.getContent()) {
                        localNumCols += cell.getColspan();
                    }
                    if (localNumCols > numberOfColumns) {
                        numberOfColumns = localNumCols;
                    }
                    tableRows.add(tableRowElement);
                    if (repeatHeader != null && repeatHeader.equalsIgnoreCase("yes") && tableRowElement.getPlace().equals((Object)TableRowElement.Place.HEADER)) {
                        ++headerRows;
                    }
                    if (repeatFooter == null || !repeatFooter.equalsIgnoreCase("yes") || !tableRowElement.getPlace().equals((Object)TableRowElement.Place.FOOTER)) continue;
                    ++footerRows;
                    continue;
                }
                invalidRowElements.add(e);
            }
            if (repeatFooter == null || !repeatFooter.equalsIgnoreCase("yes")) {
                Collections.sort(tableRows, new NormalRowComparator());
            } else {
                Collections.sort(tableRows, new RepeatedRowComparator());
            }
            PdfPTable table = new PdfPTable(numberOfColumns);
            table.setHeaderRows(headerRows + footerRows);
            table.setFooterRows(footerRows);
            TableStyleValues styleValues = this.setStyleValues(tag);
            table.setTableEvent((PdfPTableEvent)new TableBorderEvent(styleValues));
            this.setVerticalMargin(table, tag, styleValues, ctx);
            this.widenLastCell(tableRows, styleValues.getHorBorderSpacing());
            float[] columnWidths = new float[numberOfColumns];
            float[] widestWords = new float[numberOfColumns];
            float[] fixedWidths = new float[numberOfColumns];
            int[] rowspanValue = new int[numberOfColumns];
            float largestColumn = 0.0f;
            int indexOfLargestColumn = 0;
            for (TableRowElement row : tableRows) {
                int column = 0;
                for (HtmlCell cell : row.getContent()) {
                    while (rowspanValue[column] > 1) {
                        rowspanValue[column] = rowspanValue[column] - 1;
                        ++column;
                    }
                    if (cell.getRowspan() > 1 && column != numberOfColumns - 1) {
                        rowspanValue[column] = cell.getRowspan() - 1;
                    }
                    int colspan = cell.getColspan();
                    if (cell.getFixedWidth() != 0.0f) {
                        float fixedWidth = cell.getFixedWidth() + this.getCellStartWidth(cell);
                        fixedWidth /= (float)colspan;
                        for (int i = 0; i < colspan; ++i) {
                            int c = column + i;
                            if (!(fixedWidth > fixedWidths[c])) continue;
                            fixedWidths[c] = fixedWidth;
                            columnWidths[c] = fixedWidth;
                        }
                    }
                    if (cell.getCompositeElements() != null && colspan == 1) {
                        float[] widthValues = this.setCellWidthAndWidestWord(cell);
                        float cellWidth = widthValues[0] / (float)colspan;
                        float widestWordOfCell = widthValues[1] / (float)colspan;
                        for (int i = 0; i < colspan; ++i) {
                            int c = column + i;
                            if (fixedWidths[c] == 0.0f && cellWidth > columnWidths[c]) {
                                columnWidths[c] = cellWidth;
                                if (cellWidth > largestColumn) {
                                    largestColumn = cellWidth;
                                    indexOfLargestColumn = c;
                                }
                            }
                            if (!(widestWordOfCell > widestWords[c])) continue;
                            widestWords[c] = widestWordOfCell;
                        }
                    }
                    if (colspan > 1) {
                        if (LOG.isLogging(Level.TRACE)) {
                            LOG.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.table.colspan"), colspan));
                        }
                        column += colspan - 1;
                    }
                    ++column;
                }
            }
            float outerWidth = this.getTableOuterWidth(tag, styleValues.getHorBorderSpacing(), ctx);
            float initialTotalWidth = this.getTableWidth(columnWidths, 0.0f);
            float targetWidth = 0.0f;
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            float max = htmlPipelineContext.getPageSize().getWidth() - outerWidth;
            boolean tableWidthFixed = false;
            if (tag.getAttributes().get("width") != null || tag.getCSS().get("width") != null) {
                targetWidth = new WidthCalculator().getWidth(tag, htmlPipelineContext.getRootTags(), htmlPipelineContext.getPageSize().getWidth());
                if (targetWidth > max) {
                    targetWidth = max;
                }
                tableWidthFixed = true;
            } else {
                targetWidth = initialTotalWidth <= max ? initialTotalWidth : (null == tag.getParent() || null != tag.getParent() && htmlPipelineContext.getRootTags().contains(tag.getParent().getName()) ? max : this.getTableWidth(columnWidths, outerWidth));
            }
            float totalFixedColumnWidth = this.getTableWidth(fixedWidths, 0.0f);
            float targetPercentage = 0.0f;
            if (totalFixedColumnWidth == initialTotalWidth) {
                targetPercentage = targetWidth / initialTotalWidth;
                if (initialTotalWidth > targetWidth) {
                    int column = 0;
                    while (column < columnWidths.length) {
                        int n = column++;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                } else if (tableWidthFixed && targetPercentage != 1.0f) {
                    int column = 0;
                    while (column < columnWidths.length) {
                        int n = column++;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                }
            } else {
                targetPercentage = (targetWidth - totalFixedColumnWidth) / (initialTotalWidth - totalFixedColumnWidth);
                if (initialTotalWidth > targetWidth) {
                    int column;
                    float leftToReduce = 0.0f;
                    for (column = 0; column < columnWidths.length; ++column) {
                        if (fixedWidths[column] == 0.0f) {
                            if (widestWords[column] <= columnWidths[column] * targetPercentage) {
                                int n = column;
                                columnWidths[n] = columnWidths[n] * targetPercentage;
                                continue;
                            }
                            columnWidths[column] = widestWords[column];
                            leftToReduce += widestWords[column] - columnWidths[column] * targetPercentage;
                            continue;
                        }
                        if (!(fixedWidths[column] < widestWords[column])) continue;
                        columnWidths[column] = widestWords[column];
                        leftToReduce += widestWords[column] - fixedWidths[column];
                    }
                    if (leftToReduce != 0.0f) {
                        if (widestWords[indexOfLargestColumn] <= columnWidths[indexOfLargestColumn] - leftToReduce) {
                            int n = indexOfLargestColumn;
                            columnWidths[n] = columnWidths[n] - leftToReduce;
                        } else {
                            for (column = 0; leftToReduce != 0.0f && column < columnWidths.length; ++column) {
                                if (fixedWidths[column] != 0.0f || !(columnWidths[column] > widestWords[column])) continue;
                                float difference = columnWidths[column] - widestWords[column];
                                if (difference <= leftToReduce) {
                                    leftToReduce -= difference;
                                    columnWidths[column] = widestWords[column];
                                    continue;
                                }
                                int n = column;
                                columnWidths[n] = columnWidths[n] - leftToReduce;
                                leftToReduce = 0.0f;
                            }
                            if (leftToReduce != 0.0f) {
                                float pageWidth = this.getHtmlPipelineContext(ctx).getPageSize().getWidth();
                                if (this.getTableWidth(widestWords, outerWidth) < pageWidth) {
                                    targetWidth = this.getTableWidth(widestWords, outerWidth);
                                    leftToReduce = 0.0f;
                                } else {
                                    targetWidth = pageWidth - outerWidth;
                                    leftToReduce = 0.0f;
                                }
                            }
                        }
                    }
                } else if (initialTotalWidth < targetWidth) {
                    for (int column = 0; column < columnWidths.length; ++column) {
                        if (fixedWidths[column] != 0.0f) continue;
                        int n = column;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                }
            }
            try {
                table.setTotalWidth(columnWidths);
                table.setLockedWidth(true);
                table.getDefaultCell().setBorder(0);
            }
            catch (DocumentException e) {
                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
            }
            Float tableHeight = new HeightCalculator().getHeight(tag, this.getHtmlPipelineContext(ctx).getPageSize().getHeight());
            int rowNumber = 0;
            for (TableRowElement row : tableRows) {
                float rowHeight;
                int columnNumber = -1;
                Float computedRowHeight = null;
                if (tableHeight != null && tableRows.indexOf(row) == tableRows.size() - 1) {
                    float computedTableHeigt = table.calculateHeights();
                    computedRowHeight = Float.valueOf(tableHeight.floatValue() - computedTableHeigt);
                }
                for (HtmlCell cell : row.getContent()) {
                    columnNumber += cell.getColspan();
                    List compositeElements = cell.getCompositeElements();
                    if (compositeElements != null) {
                        for (Element baseLevel : compositeElements) {
                            if (!(baseLevel instanceof PdfPTable)) continue;
                            TableStyleValues cellValues = cell.getCellValues();
                            float totalBordersWidth = cellValues.isLastInRow() ? styleValues.getHorBorderSpacing() * 2.0f : styleValues.getHorBorderSpacing();
                            totalBordersWidth += cellValues.getBorderWidthLeft() + cellValues.getBorderWidthRight();
                            float columnWidth = columnWidths[columnNumber];
                            PdfPTableEvent tableEvent = ((PdfPTable)baseLevel).getTableEvent();
                            TableStyleValues innerStyleValues = ((TableBorderEvent)tableEvent).getTableStyleValues();
                            totalBordersWidth += innerStyleValues.getBorderWidthLeft();
                            ((PdfPTable)baseLevel).setTotalWidth(columnWidth - (totalBordersWidth += innerStyleValues.getBorderWidthRight()));
                        }
                    }
                    table.addCell((PdfPCell)cell);
                }
                table.completeRow();
                if (computedRowHeight != null && computedRowHeight.floatValue() > 0.0f && (rowHeight = table.getRow(rowNumber).getMaxHeights()) < computedRowHeight.floatValue()) {
                    table.getRow(rowNumber).setMaxHeights(computedRowHeight.floatValue());
                }
                ++rowNumber;
            }
            if (percentage) {
                table.setWidthPercentage(utils.parsePxInCmMmPcToPt(widthValue));
                table.setLockedWidth(false);
            }
            ArrayList<Element> elems = new ArrayList<Element>();
            if (invalidRowElements.size() > 0) {
                int i = 0;
                Tag captionTag = tag.getChildren().get(i++);
                while (!captionTag.getName().equalsIgnoreCase("caption") && i < tag.getChildren().size()) {
                    captionTag = tag.getChildren().get(i);
                    ++i;
                }
                String captionSideValue = captionTag.getCSS().get("caption-side");
                if (captionSideValue != null && captionSideValue.equalsIgnoreCase("bottom")) {
                    elems.add((Element)table);
                    elems.addAll(invalidRowElements);
                } else {
                    elems.addAll(invalidRowElements);
                    elems.add((Element)table);
                }
            } else {
                elems.add((Element)table);
            }
            return elems;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    private float calculateTargetWidth(Tag tag, float[] columnWidths, float outerWidth, WorkerContext ctx) throws NoCustomContextException {
        float targetWidth = 0.0f;
        HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
        float max = htmlPipelineContext.getPageSize().getWidth() - outerWidth;
        float start = this.getTableWidth(columnWidths, 0.0f);
        if (tag.getAttributes().get("width") != null || tag.getCSS().get("width") != null) {
            targetWidth = new WidthCalculator().getWidth(tag, htmlPipelineContext.getRootTags(), htmlPipelineContext.getPageSize().getWidth());
            if (targetWidth > max) {
                targetWidth = max;
            }
        } else {
            targetWidth = start <= max ? start : (null == tag.getParent() || null != tag.getParent() && htmlPipelineContext.getRootTags().contains(tag.getParent().getName()) ? max : this.getTableWidth(columnWidths, outerWidth));
        }
        return targetWidth;
    }

    private void widenLastCell(List<TableRowElement> tableRows, float horBorderSpacing) {
        for (TableRowElement row : tableRows) {
            List<HtmlCell> cells = row.getContent();
            HtmlCell last = cells.get(cells.size() - 1);
            last.getCellValues().setLastInRow(true);
            last.setPaddingRight(last.getPaddingRight() + horBorderSpacing);
        }
    }

    private TableStyleValues setStyleValues(Tag tag) {
        TableStyleValues styleValues = new TableStyleValues();
        Map<String, String> css = tag.getCSS();
        Map<String, String> attributes = tag.getAttributes();
        if (attributes.containsKey("border")) {
            styleValues.setBorderColor(BaseColor.BLACK);
            styleValues.setBorderWidth(utils.parsePxInCmMmPcToPt(attributes.get("border")));
        } else {
            styleValues.setBorderColorBottom(HtmlUtilities.decodeColor((String)css.get("border-bottom-color")));
            styleValues.setBorderColorTop(HtmlUtilities.decodeColor((String)css.get("border-top-color")));
            styleValues.setBorderColorLeft(HtmlUtilities.decodeColor((String)css.get("border-left-color")));
            styleValues.setBorderColorRight(HtmlUtilities.decodeColor((String)css.get("border-right-color")));
            styleValues.setBorderWidthBottom(utils.checkMetricStyle(css, "border-bottom-width"));
            styleValues.setBorderWidthTop(utils.checkMetricStyle(css, "border-top-width"));
            styleValues.setBorderWidthLeft(utils.checkMetricStyle(css, "border-left-width"));
            styleValues.setBorderWidthRight(utils.checkMetricStyle(css, "border-right-width"));
        }
        styleValues.setBackground(HtmlUtilities.decodeColor((String)css.get("background-color")));
        styleValues.setHorBorderSpacing(Table.getBorderOrCellSpacing(true, css, attributes));
        styleValues.setVerBorderSpacing(Table.getBorderOrCellSpacing(false, css, attributes));
        return styleValues;
    }

    public static float getBorderOrCellSpacing(boolean getHor, Map<String, String> css, Map<String, String> attributes) {
        float spacing = 0.0f;
        String collapse = css.get("border-collapse");
        if (collapse == null || collapse.equals("seperate")) {
            String borderSpacing = css.get("border-spacing");
            String cellSpacing = attributes.get("cellspacing");
            String borderAttr = attributes.get("border");
            if (borderSpacing != null) {
                spacing = borderSpacing.contains(" ") ? (getHor ? utils.parsePxInCmMmPcToPt(borderSpacing.split(" ")[0]) : utils.parsePxInCmMmPcToPt(borderSpacing.split(" ")[1])) : utils.parsePxInCmMmPcToPt(borderSpacing);
            } else if (cellSpacing != null) {
                spacing = utils.parsePxInCmMmPcToPt(cellSpacing);
            } else if (borderAttr != null) {
                spacing = utils.parsePxInCmMmPcToPt(borderAttr);
            }
        } else if (collapse.equals("collapse")) {
            spacing = 0.0f;
        }
        return spacing;
    }

    private float[] setCellWidthAndWidestWord(HtmlCell cell) {
        float startWidth;
        ArrayList<Float> rulesWidth = new ArrayList<Float>();
        float widestWordOfCell = 0.0f;
        float cellWidth = startWidth = this.getCellStartWidth(cell);
        List compositeElements = cell.getCompositeElements();
        if (compositeElements != null) {
            for (Element baseLevel : compositeElements) {
                if (baseLevel instanceof Phrase) {
                    for (int i = 0; i < ((Phrase)baseLevel).size(); ++i) {
                        Element inner = (Element)((Phrase)baseLevel).get(i);
                        if (!(inner instanceof Chunk)) continue;
                        cellWidth += ((Chunk)inner).getWidthPoint();
                        float widestWord = startWidth + this.getCssAppliers().getChunkCssAplier().getWidestWord((Chunk)inner);
                        if (!(widestWord > widestWordOfCell)) continue;
                        widestWordOfCell = widestWord;
                    }
                    rulesWidth.add(Float.valueOf(cellWidth));
                    cellWidth = startWidth;
                    continue;
                }
                if (baseLevel instanceof com.itextpdf.text.List) {
                    for (Element li : ((com.itextpdf.text.List)baseLevel).getItems()) {
                        rulesWidth.add(Float.valueOf(cellWidth));
                        cellWidth = startWidth + ((ListItem)li).getIndentationLeft();
                        for (Chunk c : ((ListItem)li).getChunks()) {
                            cellWidth += c.getWidthPoint();
                            float widestWord = this.getCssAppliers().getChunkCssAplier().getWidestWord(c);
                            if (!(startWidth + widestWord > widestWordOfCell)) continue;
                            widestWordOfCell = startWidth + widestWord;
                        }
                    }
                    rulesWidth.add(Float.valueOf(cellWidth));
                    cellWidth = startWidth;
                    continue;
                }
                if (!(baseLevel instanceof PdfPTable)) continue;
                rulesWidth.add(Float.valueOf(cellWidth));
                cellWidth = startWidth + ((PdfPTable)baseLevel).getTotalWidth();
                for (PdfPRow innerRow : ((PdfPTable)baseLevel).getRows()) {
                    int size = innerRow.getCells().length;
                    TableBorderEvent event = (TableBorderEvent)((PdfPTable)baseLevel).getTableEvent();
                    TableStyleValues values = event.getTableStyleValues();
                    float minRowWidth = values.getBorderWidthLeft() + (float)(size + 1) * values.getHorBorderSpacing() + values.getBorderWidthRight();
                    int celnr = 0;
                    for (PdfPCell innerCell : innerRow.getCells()) {
                        ++celnr;
                        if (innerCell == null) continue;
                        float innerWidestWordOfCell = this.setCellWidthAndWidestWord(new HtmlCell(innerCell, celnr == size))[1];
                        minRowWidth += innerWidestWordOfCell;
                    }
                    if (!(minRowWidth > widestWordOfCell)) continue;
                    widestWordOfCell = minRowWidth;
                }
                rulesWidth.add(Float.valueOf(cellWidth));
                cellWidth = startWidth;
            }
        }
        for (Float width : rulesWidth) {
            if (!(width.floatValue() > cellWidth)) continue;
            cellWidth = width.floatValue();
        }
        return new float[]{cellWidth, widestWordOfCell};
    }

    private float getTableWidth(float[] widths, float outerWidth) throws NoCustomContextException {
        float width = 0.0f;
        for (float f : widths) {
            width += f;
        }
        return width + outerWidth;
    }

    private float getTableOuterWidth(Tag tag, float horBorderSpacing, WorkerContext ctx) throws NoCustomContextException {
        float total = utils.getLeftAndRightMargin(tag, this.getHtmlPipelineContext(ctx).getPageSize().getWidth()) + utils.checkMetricStyle(tag, "border-left-width") + utils.checkMetricStyle(tag, "border-right-width") + horBorderSpacing;
        Tag parent = tag.getParent();
        if (parent != null) {
            total += utils.getLeftAndRightMargin(parent, this.getHtmlPipelineContext(ctx).getPageSize().getWidth());
        }
        return total;
    }

    private float getCellStartWidth(HtmlCell cell) {
        TableStyleValues cellStyleValues = cell.getCellValues();
        int spacingMultiplier = cell.getColspan() - 1;
        float spacing = (float)spacingMultiplier * cellStyleValues.getHorBorderSpacing();
        return spacing + cell.getPaddingLeft() + cell.getPaddingRight() + 1.0f;
    }

    private void setVerticalMargin(PdfPTable table, Tag t, TableStyleValues values, WorkerContext ctx) throws NoCustomContextException {
        float spacingBefore = 0.0f;
        float spacingAfter = 0.0f;
        for (Map.Entry<String, String> css : t.getCSS().entrySet()) {
            String key = css.getKey();
            String value = css.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                spacingBefore += utils.parseValueToPt(value, fst.getFontSize(t));
                continue;
            }
            if (!"margin-bottom".equalsIgnoreCase(key)) continue;
            float marginBottom = utils.parseValueToPt(value, fst.getFontSize(t));
            spacingAfter += marginBottom;
            this.getHtmlPipelineContext(ctx).getMemory().put("lastMarginBottom", Float.valueOf(marginBottom));
        }
        table.setSpacingBefore(spacingBefore);
        table.setSpacingAfter(spacingAfter);
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepeatedRowComparator
    implements Comparator<TableRowElement> {
        private RepeatedRowComparator() {
        }

        @Override
        public int compare(TableRowElement o1, TableRowElement o2) {
            return o1.getPlace().getRepeated().compareTo(o2.getPlace().getRepeated());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NormalRowComparator
    implements Comparator<TableRowElement> {
        private NormalRowComparator() {
        }

        @Override
        public int compare(TableRowElement o1, TableRowElement o2) {
            return o1.getPlace().getNormal().compareTo(o2.getPlace().getNormal());
        }
    }
}

