/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.net;

import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.ReadingProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileRetrieveImpl
implements FileRetrieve {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRetrieveImpl.class);
    private final List<File> rootdirs = new CopyOnWriteArrayList<File>();
    private final List<String> urls = new CopyOnWriteArrayList<String>();

    public FileRetrieveImpl() {
    }

    public FileRetrieveImpl(String[] strings) {
        this();
        for (String s : strings) {
            if (s.startsWith("http") || s.startsWith("https")) {
                this.urls.add(s);
                continue;
            }
            File f = new File(s);
            if (!f.isDirectory()) continue;
            this.rootdirs.add(f);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFromHref(String href, ReadingProcessor processor) throws IOException {
        boolean isfile;
        File f;
        URL url;
        block9: {
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug(String.format(LocaleMessages.getInstance().getMessage("retrieve.file.from"), href));
            }
            url = null;
            f = null;
            isfile = false;
            try {
                url = new URL(href);
            }
            catch (MalformedURLException e) {
                try {
                    url = this.detectWithRootUrls(href);
                }
                catch (MalformedURLException e1) {
                    f = new File(href);
                    isfile = true;
                    if (f.isFile() && f.canRead()) break block9;
                    isfile = false;
                    for (File root : this.rootdirs) {
                        f = new File(root, href);
                        if (!f.isFile() || !f.canRead()) continue;
                        isfile = true;
                        break;
                    }
                }
            }
        }
        InputStream in = null;
        if (null != url) {
            in = url.openStream();
        } else if (isfile) {
            in = new FileInputStream(f);
        }
        this.read(processor, in);
    }

    private URL detectWithRootUrls(String href) throws MalformedURLException {
        for (String root : this.urls) {
            try {
                return new URL(root + href);
            }
            catch (MalformedURLException e) {
            }
        }
        throw new MalformedURLException();
    }

    public void processFromStream(InputStream in, ReadingProcessor processor) throws IOException {
        this.read(processor, in);
    }

    private void read(ReadingProcessor processor, InputStream in) throws IOException {
        try {
            int inbit = -1;
            while ((inbit = in.read()) != -1) {
                processor.process(inbit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeWorkerException(e);
            }
        }
    }

    public void addRootDir(File dir) {
        this.rootdirs.add(dir);
    }

    public void addURL(String url) {
        this.urls.add(url);
    }
}

