/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.ctx.WorkerContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWorker
implements XMLParserListener {
    private Tag current = null;
    private final Pipeline<?> rootpPipe;
    private static ThreadLocal<WorkerContextImpl> context = new ThreadLocal<WorkerContextImpl>(){

        @Override
        protected WorkerContextImpl initialValue() {
            return new WorkerContextImpl();
        }
    };
    private final boolean parseHtml;

    public XMLWorker(Pipeline<?> pipeline, boolean parseHtml) {
        this.parseHtml = parseHtml;
        Pipeline<?> p = this.rootpPipe = pipeline;
        while (null != (p = this.setCustomContext(p))) {
        }
    }

    public void parse(InputStream in) throws IOException {
        Pipeline<?> p = this.rootpPipe;
        while (null != (p = this.setCustomContext(p))) {
        }
        XMLParser parser = new XMLParser(this.parseHtml, this);
        parser.parse(in);
    }

    public void parse(Reader in) throws IOException {
        Pipeline<?> p = this.rootpPipe;
        while (null != (p = this.setCustomContext(p))) {
        }
        XMLParser parser = new XMLParser(this.parseHtml, this);
        parser.parse(in);
    }

    private Pipeline<?> setCustomContext(Pipeline<?> pipeline) {
        try {
            WorkerContextImpl ctx = context.get();
            pipeline.setContext(ctx);
            Object cc = pipeline.getNewCustomContext();
            ctx.add(pipeline.getContextKey(), (CustomContext)cc);
        }
        catch (NoCustomContextException noCustomContextException) {
            // empty catch block
        }
        return pipeline.getNext();
    }

    @Override
    public void startElement(String tag, Map<String, String> attr, String ns) {
        if (this.parseHtml) {
            tag = tag.toLowerCase();
        }
        Tag t = new Tag(tag, attr, ns);
        if (null != this.current) {
            this.current.addChild(t);
        }
        this.current = t;
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.open(t, po))) {
            }
        }
        catch (PipelineException e) {
            throw new RuntimeWorkerException(e);
        }
    }

    @Override
    public void endElement(String tag, String ns) {
        String thetag = null;
        thetag = this.parseHtml ? tag.toLowerCase() : tag;
        if (null != this.current && !thetag.equals(this.current.getTag())) {
            throw new RuntimeWorkerException(String.format(LocaleMessages.getInstance().getMessage("tag.invalidnesting"), thetag, this.current.getTag()));
        }
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.close(this.current, po))) {
            }
        }
        catch (PipelineException e) {
            throw new RuntimeWorkerException(e);
        }
        finally {
            if (null != this.current) {
                this.current = this.current.getParent();
            }
        }
    }

    @Override
    public void text(byte[] b) {
        if (null != this.current && b.length > 0) {
            Pipeline<?> wp = this.rootpPipe;
            ProcessObject po = new ProcessObject();
            try {
                while (null != (wp = wp.content(this.current, b, po))) {
                }
            }
            catch (PipelineException e) {
                throw new RuntimeWorkerException(e);
            }
        }
    }

    @Override
    public void unknownText(String text) {
    }

    @Override
    public void comment(String comment) {
    }
}

