/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl.datatype;

import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.ICssDataTypeValidator;

public class CssIntegerNumberValueValidator
implements ICssDataTypeValidator {
    private final boolean allowedNegative;
    private final boolean allowedZero;

    public CssIntegerNumberValueValidator(boolean allowedNegative, boolean allowedZero) {
        this.allowedNegative = allowedNegative;
        this.allowedZero = allowedZero;
    }

    @Override
    public boolean isValid(String objectString) {
        if (objectString == null) {
            return false;
        }
        if ("initial".equals(objectString) || "inherit".equals(objectString) || "unset".equals(objectString)) {
            return true;
        }
        if (!CssTypesValidationUtils.isIntegerNumber(objectString)) {
            return false;
        }
        if (CssTypesValidationUtils.isNegativeValue(objectString) && !this.allowedNegative) {
            return false;
        }
        return !CssTypesValidationUtils.isZero(objectString) || this.allowedZero;
    }
}

